<?php

namespace App\Http\Requests\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Language;
use Illuminate\Foundation\Http\FormRequest;

class UserNotifyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $languages = Language::active()->get();
        $rules = [];
        foreach ($languages as $lang) {
            if ($lang->is_default) {
                $rules["message_$lang->code"] = "required|string|max:600";
            } else {
                $rules["message_$lang->code"] = "nullable|string|max:600";
            }
        }


        return $rules;
    }
}
