<?php

namespace App\Http\Requests\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Language;
use App\Enums\UserRoleEnum;
use Illuminate\Foundation\Http\FormRequest;

class NotificationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $languages = Language::active()->get();
        $rules = [];
        $roles = implode(",", UserRoleEnum::values()) . ",all";
        $rules['type'] = ['required', 'string', 'in:' . $roles];
        foreach ($languages as $lang) {
            if ($lang->is_default) {
                $rules["message_$lang->code"] = "required|string|max:255";
            } else {
                $rules["message_$lang->code"] = "nullable|string|max:255";
            }
        }



        return $rules;
    }
}
