<?php

namespace App\Http\Requests\Admin\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class VariableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "name" => "required|string|max:255",
            "default_value" => "required|string|max:255",
        ];
    }

    public function messages(): array
    {
        return [
            // رسائل name
            'name.required' => __('validation.The name field is required'),
            'name.string' => __('validation.The name must be a string'),
            'name.max' => __('validation.The name may not be greater than :max characters'),

            // رسائل default_value
            'default_value.required' => __('validation.The default value field is required'),
            'default_value.string' => __('validation.The default value must be a string'),
            'default_value.max' => __('validation.The default value may not be greater than :max characters'),
        ];
    }
}
