<?php

namespace App\Http\Requests\Admin\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class GeneralAnalysisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {

        return [
            "name" => "required|string|max:255",
            "variables" => "nullable|array",
            "variables.*" => "required|integer|exists:variables,id,is_delete,0",
            "other_variables" => "nullable|array",
            "other_variables.*.name" => "required_with:other_variables.*.default_value|nullable|string|max:255",
            "other_variables.*.default_value" => "required_with:other_variables.*.name|nullable|string|max:255",
        ];
    }

    public function messages(): array
    {
        return [
            // رسائل name
            'name.required' => __('validation.The name field is required'),
            'name.string' => __('validation.The name must be a string'),
            'name.max' => __('validation.The name may not be greater than :max characters'),

            // رسائل variables
            'variables.array' => __('validation.The variables must be an array'),

            // رسائل variables.*
            'variables.*.required' => __('validation.Each variable is required'),
            'variables.*.integer' => __('validation.Each variable must be an integer'),
            'variables.*.exists' => __('validation.The selected variable is invalid or does not meet the conditions'),

            // رسائل other_variables
            'other_variables.array' => __('validation.The other variables must be an array'),

            // رسائل other_variables.*.name
            'other_variables.*.name.required_with' => __('validation.The other variable name is required when the default value is present'),
            'other_variables.*.name.string' => __('validation.The other variable name must be a string'),
            'other_variables.*.name.max' => __('validation.The other variable name may not be greater than :max characters'),

            // رسائل other_variables.*.default_value
            'other_variables.*.default_value.required_with' => __('validation.The other variable default value is required when the name is present'),
            'other_variables.*.default_value.string' => __('validation.The other variable default value must be a string'),
            'other_variables.*.default_value.max' => __('validation.The other variable default value may not be greater than :max characters'),
        ];
    }
}
