<?php

namespace App\Http\Middleware;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Closure;
use App\Models\Language;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ChangeLangApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $def_lang = Language::where('is_default' , 1)->value('code');
        $lang = $request->header('x-lang');
        // $check=Language::where('code',$lang)
        if (!in_array($lang, ["ar", "en"])) {
            abort(403);
        }

        if ($lang != app()->getLocale()) {
            app()->setLocale($lang);
        }else
        {
            app()->setLocale($def_lang);
        }


        return $next($request);
    }
}
