<?php
namespace App\Http\Helpers;

use Illuminate\Http\Response;

class ResponseHelper{
    /**
     * send response success
     * @param array $data
     * @param string $message
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    public static function sendResponseSuccess($data=null , int  $code = 200  , $message=null ){

        $message = $message ?? __('messages.done successfully');
        $response = self::responseData( true , $code  , $data , $message);
        return response()->json($response, $code);
    }


       /**
     * send response success
     * @param array $data
     * @param string $message
     * @param int $code
     * @return \Illuminate\Http\JsonResponse
     */
    public static function sendResponseSuccessWithMessage($message){

        $response = self::responseData( true , 200  , null , $message);
        return response()->json($response, 200);
    }

    /**
     *  Send response error
     * @param array $data
     * @param mixed $message
     * @param mixed $code
     * @return \Illuminate\Http\JsonResponse
     */
    public static function sendResponseError( $data , int  $code  , $message=null ){

        $response = self::responseData( false , $code  , $data , $message);
        return response()->json($response, $code);
    }




    private static function responseData(bool $status , int $status_code , $data , $message){

        $message = $message ? $message : Response::$statusTexts[$status_code];

        return  [
            'status' =>  $status,
            'status_code'=>$status_code,
            'data'    => $data,
            'message' =>  $message,
        ];
    }

    public static function sendNotFound(){
        return self::sendResponseError( null , Response::HTTP_NOT_FOUND , __('messages.Notfound'));
    }

    public static function sendBadRequest($message){
        return self::sendResponseError( null , Response::HTTP_BAD_REQUEST ,$message);
    }


}
