<?php

namespace App\Http\Helpers;

use App\Enums\NotificationTypeEnum;
use App\Models\User;
use App\Enums\UserRoleEnum;
use App\Models\Notification;
use App\Events\NotificationEvent;
use Illuminate\Support\Facades\Http;
use App\Http\Resources\NotificationResource;
use App\Models\Language;
use Carbon\Carbon;

class HelperNotification
{
    private  static $users_ids = [];
    private  static $message;
    private  static $type;
    private  static $params = null;
    private  static $is_fcm = false;
    private  static $is_pusher = false;
    private  static $is_mail = false;
    private  static $is_db = false;
    private  static $from_user_id = null;
    /**
     * set users id
     * @param array $users_ids
     * @return    HelperNotification
     */
    public static function set_users_ids(array $users_ids): HelperNotification
    {
        self::$users_ids = $users_ids;
        return new HelperNotification;
    }

    /**
     * set message
     * @param array $message
     * @return   HelperNotification
     */

    public static function set_message(array $message): HelperNotification
    {
        self::$message = $message;
        return new HelperNotification;
    }


    /**
     * set type => App\Enums\NotificationTypeEnum
     * @param string $type
     * @return   HelperNotification
     */


    public static function set_type(string $type): HelperNotification
    {
        self::$type = $type;
        return new HelperNotification;
    }


    /**
     * set from_user_id
     * @param int $id
     * @return   HelperNotification
     */


    public static function set_from_user_id($from_user_id): HelperNotification
    {
        self::$from_user_id = $from_user_id;
        return new HelperNotification;
    }


    /**
     * set params
     * @param  $params
     * @return   HelperNotification
     */

    public static function set_params($params): HelperNotification
    {

        self::$params = $params;
        return new HelperNotification;
    }












    /**
     *@return array $users_ids
     */
    public static function get_users_ids(): array
    {
        return self::$users_ids;
    }


    /**
     *@return array $message
     */
    public static function get_message(): array
    {
        return self::$message;
    }
    /**
     *@return string $type
     */
    public static function get_type(): string
    {
        return self::$type;
    }


      /**
     *@return string $id
     */
    public static function get_from_user_id()
    {
        return self::$from_user_id;
    }


    /**

     */
    public static function get_params()
    {

        return self::$params;
    }



    /**
     * send pusher
     * @return   HelperNotification
     */
    public static function send_pusher()
    {
        self::$is_pusher = true;
        return new HelperNotification;
    }

    /**
     * send fcm
     * @return   HelperNotification
     */
    public static function send_fcm()
    {
        self::$is_fcm = true;
        return new HelperNotification;
    }


    /**
     * send mail
     * @return   HelperNotification
     */
    public static function send_mail()
    {
        self::$is_mail = true;
        return new HelperNotification;
    }

    /**
     * send DB
     * @return   HelperNotification
     */
    public static function send_db()
    {
        self::$is_db = true;
        return new HelperNotification;
    }


    /**
     * send all (FCM , Pusher . Mail)
     * @return   HelperNotification
     */
    public static function send_all_channel()
    {
        self::$is_fcm = true;
        self::$is_pusher = true;
        self::$is_mail = true;
        self::$is_db = true;
        return new HelperNotification;
    }



    public static function push_notification()
    {

        $base_data = [
            "message" => json_encode(self::get_message()),
            "notification_type" => self::get_type(),
            "from_user_id" => self::get_from_user_id(),
            "params" => self::get_params() ? self::get_params()   : null,
            "created_at" => Carbon::now(),
        ];





        $db_data = [];
        $pusher_channels = [];

        foreach (self::get_users_ids() as $id) {

            $db_data[] = array_merge(['user_id' => $id], $base_data);
            $pusher_channels[] = "channel-notify-$id";
        }


        if (self::$is_db) {

            //dd($db_data);
            Notification::insert($db_data);
        }


        $pusher_and_fcm_data = $base_data;
        $pusher_and_fcm_data["message"]  = self::get_message_default();
        $pusher_and_fcm_data["url"]  =  self::get_notification_url(self::get_type(), self::get_params() ? self::get_params()   : null);
        $pusher_and_fcm_data["icon"]  =  asset('notification_icons/' . self::get_type() . '.png');


        if (self::$is_pusher) {
            event(new NotificationEvent($pusher_and_fcm_data, $pusher_channels, "channel-notify"));
        }


        if (self::$is_fcm) {

            $tokens = User::whereIn('id', self::get_users_ids())->pluck('fcm_token')->toArray();

            foreach($tokens as $token){
                $message =  $base_data['message'];
                $message =(array) json_decode($message);

                if(isset($message[app()->getLocale()])){
                    $message = $message[app()->getLocale()];
                }else{
                    $message = $message["ar"];

                }

                if($token){
                    HelperApp::send_fcm($token , $message);
                }
            }

        }
    }




    private static function get_message_default()
    {
        $messages = self::get_message();

        $users_ids = self::get_users_ids();


        $default_lang_app  = Language::where("is_default", true)->first();

        $first_message_language_code  = array_key_first($messages);
        $default_message = $messages[$first_message_language_code];


        if (isset($messages[$default_lang_app['code']])) {

            $default_message = $messages[$default_lang_app['code']];
        }

        if (count($users_ids) == 1) {
            $user  = User::where("id", $users_ids[0])->first();
            if (isset($messages[$user['lang']])) {

                $default_message = $messages[$user['lang']];
            }
        }


        return $default_message;
    }






    public static function get_notification_url($type, $param)
    {
        if ($type == NotificationTypeEnum::JoinUserToAdmin->value) {
            return "users";
        } else {
            return null;
        }
    }
}
