<?php

namespace App\Http\Helpers;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;

class HelperFile
{
    public static function uploadMulti($files, $type)
    {
        $names = [];
        foreach ($files as $file) {
            $extenstion = $file->getClientOriginalExtension();
            $fileName = self::randText() . "." . $extenstion;
            $file->move(self::folderSave() . $type, $fileName);
            $names[] = ['name' => $fileName];
        }
        return $names;
    }
    /*       $file = $request->file('file');

        // Specify the type (e.g., 'images' or 'avatars')
        $type = 'images'; // Example type

        // Upload the file using the helper function
        $uploadResult = FileHelper::upload($file, $type);
*/

    public static function upload($file, $type, $invert = false)
    {

        $extenstion = $file->getClientOriginalExtension();
        $fileName = self::randText() . "." . $extenstion;
        $path_file = "uploads/" . trim($type, "/") . "/" . $fileName;
        if ($invert && in_array(strtolower($extenstion), ['jpg', 'jpeg', 'png'])) {
            $path_directory = self::folderSave() . $type; // المسار إلى المجلد

            if (!is_dir($path_directory)) {
                mkdir($path_directory, 0755, true); // أنشئ المجلد مع الصلاحيات المناسبة
            }
            $manager = new ImageManager(new Driver());
            $file = $manager->read($file);
            $file = $file->resize(null, null, function ($constraint) {
                $constraint->aspectRatio();
            })->save($path_directory . '/' . $fileName, quality: 60);
        } else {

            $file->move(self::folderSave() . $type, $fileName);
        }
        return  [
            'path' => $path_file,
        ];
    }
    // public static function upload($file, $type)
    // {

    //     $extenstion = $file->getClientOriginalExtension();
    //     $fileName = self::randText() . "." . $extenstion;
    //     $file->move(self::folderSave() . $type, $fileName);
    //     $path_file = "uploads/" . trim($type, "/") . "/" . $fileName;
    //     return  ['path' => $path_file];
    // }


    public static function deleteMultiFiles($files, $type = null)
    {
        foreach ($files as $file) {

            if ($file) {
                if ($type) {
                    if (File::exists($type . "/" . $file)) {
                        unlink($type . "/" . $file);
                    }
                } else {
                    if (File::exists($file)) {
                        unlink($file);
                    }
                }
            }
        }
    }

    public static function delete($fileName, $type = null)
    {

        if ($type) {
            if (File::exists($type . "/" . $fileName)) {
                unlink($type . "/" . $fileName);
            }
        } else {

            if (File::exists($fileName)) {
                unlink($fileName);
            }
        }
    }



    private static function randText()
    {
        return Str::random(20) . time();
    }


    private static function folderSave()
    {
        return  public_path('uploads/');
    }

    public static function files_type()
    {
        return [
            "jpg" => "image",
            "png" => "image",
            "jpeg" => "image",
            "mp4" => "video",
        ];
    }
}
