<?php

namespace App\Http\Helpers;

use App\Models\User;
use App\Enums\UserRoleEnum;
use Illuminate\Http\Response;

class HelperData
{



    public static function get_ids_admin()
    {
        return User::where('type', UserRoleEnum::Admin->value)->pluck('id')->toArray();
    }




    // public static function get_ids_client()
    // {
    //     return User::where('type', UserRoleEnum::Client->value)->pluck('id')->toArray();
    // }

    // public static function get_ids_trainer()
    // {
    //     return User::where('type', UserRoleEnum::Trainer->value)->pluck('id')->toArray();
    // }

    // public static function get_ids_doctor()
    // {
    //     return User::where('type', UserRoleEnum::Doctor->value)->pluck('id')->toArray();
    // }

    public static function get_ids_all()
    {
        return User::where('type', "!=", UserRoleEnum::Admin->value)->pluck('id')->toArray();
    }


    public static function get_notify($model, $field, $date = null)
    {
        $data = $model::when(isset($date), function ($q) use ($date, $field) {
            $q->where($field, $date);
        })->when(!isset($date), function ($q) use ($field) {
            $q->whereIn($field, [now()->format('Y-m-d'), now()->subDay()->format('Y-m-d'), now()->addDay()->format('Y-m-d')]);
        })->orderBy('id', 'desc')->first();

        return $data;
    }
}
