<?php

namespace App\Http\Helpers;

use App\Models\User;
use App\Models\Order;
use App\Models\Coupon;
use GuzzleHttp\Client;
use App\Models\CatchLog;
use App\Enums\UserRoleEnum;
use Illuminate\Http\Response;
use App\Models\AnalysisPatient;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use App\Http\Resources\UserAuthResource;
use Google\Auth\HttpHandler\HttpHandlerFactory;
use Google\Auth\Credentials\ServiceAccountCredentials;
use App\Http\Resources\QualityManagement\ChamperResource;

class HelperApp
{
    public static function set_log_catch($fun_name, $message)
    {
        Log::info(["error_catch" => [
            "function_name" => $fun_name,
            "message" => $message,
            "date" => date('Y-m-d h:i')
        ]]);

        CatchLog::create([
            "function_name" => $fun_name,
            "message" => $message
        ]);
    }

    public static function get_user_data_auth()
    {
        $user = User::findOrfail(auth('api')->id());
        $user->token = request()->bearerToken();
        return new UserAuthResource($user);
    }

    public static function get_ids_admin()
    {
        return User::where('type', UserRoleEnum::Admin->value)->pluck('id')->toArray();
    }


    public static function get_step_data($analysis_patient)
    {



        $steps = self::get_steps();
        foreach ($steps as $key => $step) {

            $step_day = explode("_", $step);


            if ($step_day[1] == "4" && $analysis_patient->step_4_complete) {
                if (!$analysis_patient->step_5) {
                    return [
                        "step_now" => "step_4_day_6",
                        "next_step" => "step_5",
                    ];
                } else {


                    $sub_steps     = ["10" => "step_5", "11" => "step_6_freezings", "12" => "step_6_thawings", "13" => "step_7"];
                    foreach ($sub_steps as $sub_key => $sub_step) {
                        if (!$analysis_patient->$sub_step) {
                            $key_now = $sub_key - 1;


                            return [
                                "step_now" => isset($sub_steps[$key_now]) ? $sub_steps[$key_now]  : null,
                                "next_step" => $sub_step,
                            ];
                        }
                    }
                }
            } else {

                if (!$analysis_patient->$step) {
                    $key_now = $key - 1;

                    return [
                        "step_now" => isset($steps[$key_now]) ? $steps[$key_now]  : null,
                        "next_step" => $step,
                    ];
                }
            }
        }

        return [
            "step_now" => "step_7",
            "next_step" => null,
        ];
    }


    public static function get_step_data_resource($analysis_patient)
    {



        $steps = self::get_steps();

        foreach ($steps as $key => $step) {

            $step_day = explode("_", $step);


            if ($step_day[1] == "4" && $analysis_patient->step_4_complete) {

                if (!$analysis_patient->step_5) {

                    return [
                        "step_now" => "step_4_day_6",
                        "next_step" => "step_5",
                    ];
                } else {



                    $sub_steps     = ["10" => "step_5", "11" => "step_6_freezings", "12" => "step_6_thawings", "13" => "step_7"];
                    foreach ($sub_steps as $sub_key => $sub_step) {
                        if (!$analysis_patient->$sub_step) {
                            $key_now = $sub_key - 1;


                            return [
                                "step_now" => isset($sub_steps[$key_now]) ? $sub_steps[$key_now]  : null,
                                "next_step" => $sub_step,
                            ];
                        }
                    }
                }
            } else {

                if (!$analysis_patient->$step) {
                    $key_now = $key - 1;

                    return [
                        "step_now" => isset($steps[$key_now]) ? $steps[$key_now]  : null,
                        "next_step" => $step,
                    ];
                }
            }
        }

        return [
            "step_now" => "step_7",
            "next_step" => null,
        ];
    }


    public static  function get_steps()
    {
        return [
            "1" => "step_1",
            "2" => "step_2",
            "3" => "step_3",
            "4" => "step_4_day_1",
            "5" => "step_4_day_2",
            "6" => "step_4_day_3",
            "7" => "step_4_day_4",
            "8" => "step_4_day_5",
            "9" => "step_4_day_6",
            "10" => "step_5",
            "11" => "step_6_freezings",
            "12" => "step_6_thawings",
            "13" => "step_7",
        ];
    }

    public static function handle_resource_quality_management($data,  $_this)
    {

        if ($_this->device_id) {
            $data['device'] = [
                "id" => $_this->device->id,
                "name" => $_this->device->name,
            ];
        }

        if ($_this->user_id) {
            $data['user'] = [
                "id" => $_this->user->id,
                "name" => $_this->user->name,
            ];
        }

        if ($_this->champers) {
            $data['champers'] = ChamperResource::collection($_this->champers);
        }


        unset($data['updated_at'],  $data['user_id'], $data['device_id']);

        return $data;
    }


    public static function send_fcm($token, $message, $data = [])
    {

        $jsonKeyFilePath = 'ivflabs-7f772-firebase-adminsdk-fbank-ec33f8936d.json';
        $scopes = ['https://www.googleapis.com/auth/cloud-platform'];
        $credentials = new ServiceAccountCredentials($scopes, $jsonKeyFilePath);
        $httpHandler = HttpHandlerFactory::build(new Client());
        $credentials->fetchAuthToken($httpHandler);
        $accessToken = $credentials->getLastReceivedToken()['access_token'];





        if ($token) {
            $res = Http::withToken($accessToken)
                ->post("https://fcm.googleapis.com/v1/projects/ivflabs-7f772/messages:send", [
                    'message' => [
                        'token' => $token,
                        'notification' => [
                            'title' =>  config('app.name'),
                            'body' => $message,
                        ],
                        //'data'=>$data
                    ],
                ]);

            Log::info(["res" => $res->json()]);
        } else {
            Log::info(["not token"]);
        }
    }
}
