<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use PDO;
use Throwable;
use Carbon\Carbon;
use App\Models\Step1;
use App\Models\Step2;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Helpers\HelperApp;
use App\Models\AnalysisPatient;
use App\Http\Helpers\HelperFile;
use App\Models\TestGroupStepOne;
use App\Models\TestGroupStepTwo;
use App\Models\TestGroupStepFive;
use App\Models\TestGroupStepFour;
use App\Models\TestGroupStepSeven;
use App\Models\TestGroupStepThree;
use Illuminate\Support\Facades\DB;
use App\Enums\NotificationTypeEnum;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Models\TestGroupStepFourData;
use App\Models\TestGroupStepFourFile;
use App\Models\TestGroupStepSixThawing;
use App\Models\TestGroupStepThreeFiles;
use App\Http\Helpers\HelperNotification;
use App\Models\TestGroupStepSixFreezing;
use App\Http\Resources\TestGroupResource;
use App\Http\Resources\TestGroup\Step4Resource;
use App\Http\Resources\TestGroup\Step6Resource;
use App\Http\Resources\TestGroup\Step6_2Resource;
use App\Http\Requests\Api\TestGroup\StepFiveRequest;
use App\Http\Requests\Api\TestGroup\StepFourRequest;
use App\Http\Requests\Api\TestGroup\StepSevenRequest;
use App\Http\Requests\Api\TestGroup\StepThreeRequest;
use App\Http\Requests\Api\TestGroup\StepOneAndTwoRequest;
use App\Http\Requests\Api\TestGroup\StepSixThawingRequest;
use App\Http\Requests\Api\TestGroup\StepSixFreezingRequest;

class TestGroupController extends Controller
{
    public function index()
    {

        $data = AnalysisPatient::where("type", "test_group")->orderBy('id', 'desc')
            ->when(request('key_words'), function ($q) {
                $q->whereHas("patient",  function ($q) {
                    $q->where("name", "like", "%" . request('key_words') . "%")
                        ->orWhere("other_name", "like", "%" . request('key_words') . "%")
                        ->orWhere("other_medical_file_number", "like", "%" . request('key_words') . "%")
                        ->orWhere("medical_file_number", "like", "%" . request('key_words') . "%");
                });
            })
            ->when(request('from_date'), function ($q) {
                $q->where("data", ">=", request('from_date'));
            })
            ->when(request('to_date'), function ($q) {
                $q->where("data", "<=", request('to_date'));
            })
            ->with(['patient', 'doctor'])->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(TestGroupResource::collection($data)->response()->getData());
    }


    public function step_one_or_step_two(StepOneAndTwoRequest $request)
    {



        $model = $request->step == "1" ? TestGroupStepOne::class : TestGroupStepTwo::class;








        $check_step = $this->check_step(HelperApp::get_steps()[$request->step], $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }


        $data = $request->validated();
        unset($data['step']);
        $data['user_id'] = auth('api')->id();

        $step_data = $model::create($data);

        $notify_type = $request->step == "1" ? NotificationTypeEnum::StepOne->value : NotificationTypeEnum::StepTwo->value;
        HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " . $step_data->tragger_time , "en" => "A date has been set for the procedure " . $step_data->tragger_time])
            ->set_params($step_data->id)
            ->set_type($notify_type)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();

        return ResponseHelper::sendResponseSuccess(null);
    }


    public function step_three(StepThreeRequest $request)
    {
        $check_step = $this->check_step("step_3", $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }

        $data = $request->validated();
        $data['user_id'] = auth('api')->id();

        $test_group_step_three = TestGroupStepThree::create($data);

        $files = [];


        if ($request->attachments && count($request->attachments)) {

            foreach ($request->attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file, "patients")['path'],
                    "test_group_step_three_id" => $test_group_step_three->id,
                ];
            }

            TestGroupStepThreeFiles::insert($files);
        }

        HelperNotification::set_users_ids([$test_group_step_three->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " . $test_group_step_three->time . "", "en" => "A date has been set for the procedure " . $test_group_step_three->time . ""])
            ->set_params($test_group_step_three->id)
            ->set_type(NotificationTypeEnum::StepThree->value)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();


        return ResponseHelper::sendResponseSuccess(null);
    }


    public function step_four(StepFourRequest $request)
    {


        DB::beginTransaction();
        try {

            $step = "step_4_day_" . $request->day;
            $check_step = $this->check_step($step, $request);
            if (!$check_step['status']) {
                return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
            }

            $data = [
                'blastocyst' => $request->blastocyst,
                "analysis_patient_id" => $request->analysis_patient_id,
                "day" => $request->day,
                "number_oocyte_fertilized" => $request->number_oocyte_fertilized,
                "abnormal_fertilized" => $request->abnormal_fertilized,
                "user_id" => $request->user_id,
                "report" => $request->report,
            ];

            $is_complete = 0;
            if (request('is_complete') || $request->day == 6) {
                $is_complete = true;
            }
            $data['is_complete'] = $is_complete;


            $step_data = TestGroupStepFour::create($data);

            if ($request->media && count($request->media)) {
                $files = [];
                foreach ($request->media as $file) {
                    $files[] = [
                        "test_group_step_four_id" => $step_data->id,
                        "path" => HelperFile::upload($file, "group-test", true)['path'],
                    ];
                }

                TestGroupStepFourFile::insert($files);
            }


            if ($request->data && count($request->data)) {
                $data = [];
                foreach ($request->data as $item) {
                    $data[] = [
                        "test_group_step_four_id" => $step_data->id,
                        "number_embryos" => $item['number_embryos'],
                        "number_cell" => $item['number_cell'],
                        "number_grade" => $item['number_grade'],
                        "time" => $item['time'],
                    ];
                }

                TestGroupStepFourData::insert($data);
            }


            HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
                ->set_message(["ar" => "تم تحديد معاد عملية لليوم " . $step_data->day , "en" => "A date has been set for the procedure for day" .  $step_data->day])
                ->set_params($step_data->id)
                ->set_type(NotificationTypeEnum::StepFour->value)
                ->send_db()
                ->send_fcm()
                //  ->send_pusher()
                ->push_notification();



            DB::commit();
            return ResponseHelper::sendResponseSuccess(null);
        } catch (Throwable $e) {
            DB::rollBack();
            HelperApp::set_log_catch("store step 4", $e->getMessage());
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }


    public function step_five(StepFiveRequest $request)
    {
        $check_step = $this->check_step("step_5", $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }

        $data = $request->validated();
        $data['user_id'] = auth('api')->id();
        $step_data = TestGroupStepFive::create($data);

        $date = Carbon::parse($step_data->date)->format('Y-m-d H:i:s');
        HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " . $date . "", "en" => "A date has been set for the procedure " . $date . ""])
            ->set_params($step_data->id)
            ->set_type(NotificationTypeEnum::StepFive->value)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();

        return ResponseHelper::sendResponseSuccess(null);
    }


    public function step_six_freezing(StepSixFreezingRequest $request)
    {
        $check_step = $this->check_step("step_6_freezings", $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }

        $data = $request->validated();
        $data['user_id'] = auth('api')->id();
        $step_data = TestGroupStepSixFreezing::create($data);

        $date = Carbon::parse($step_data->date)->format('Y-m-d H:i:s');

        HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " .$date. "", "en" => "A date has been set for the procedure " . $date . ""])
            ->set_params($step_data->id)
            ->set_type(NotificationTypeEnum::StepSix->value)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();
        return ResponseHelper::sendResponseSuccess(null);
    }

    public function step_six_thawing(StepSixThawingRequest $request)
    {
        $check_step = $this->check_step("step_6_thawings", $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }

        $data = $request->validated();
        $data['user_id'] = auth('api')->id();
        $step_data = TestGroupStepSixThawing::create($data);


        $date = Carbon::parse($step_data->date)->format('Y-m-d H:i:s');


        HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " . $date . "", "en" => "A date has been set for the procedure " . $date. ""])
            ->set_params($step_data->id)
            ->set_type(NotificationTypeEnum::StepSix->value)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();
        return ResponseHelper::sendResponseSuccess(null);
    }


    public function step_seven(StepSevenRequest $request)
    {
        $check_step = $this->check_step("step_7", $request);
        if (!$check_step['status']) {
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST,  $check_step['message']);
        }

        $data = $request->validated();
        $data['user_id'] = auth('api')->id();
        $step_data = TestGroupStepSeven::create($data);
        $date = Carbon::parse($step_data->date)->format('Y-m-d H:i:s');

        HelperNotification::set_users_ids([$step_data->analysis_patient->doctor_id])
            ->set_message(["ar" => "تم تحديد معاد عملية بتاريخ " . $date. "", "en" => "A date has been set for the procedure " . $date . ""])
            ->set_params($step_data->id)
            ->set_type(NotificationTypeEnum::StepSeven->value)
            ->send_db()
            ->send_fcm()
            //  ->send_pusher()
            ->push_notification();
        return ResponseHelper::sendResponseSuccess(null);
    }



    private function check_step($step, $request)
    {


        $analysis_patient = AnalysisPatient::find($request->analysis_patient_id);

        if ($analysis_patient->$step) {
            return [
                "status" => false,
                "message" =>  __("messages.The stage has been recorded before"),
            ];
        }




        if (!in_array($step, ["step_6_freezings", "step_6_thawings", "step_7"])) {
            if ($step == "step_5") {
                if (!$analysis_patient->step_4_complete) {
                    return [
                        "status" => false,
                        "message" => __("messages.Record the previous stage"),
                    ];
                }
            } else {
                foreach (HelperApp::get_steps() as $key => $val) {

                    if ($step == $val) {

                        $key_step_prev = $key - 1;
                        $step_prev = isset(HelperApp::get_steps()[$key_step_prev]) ? HelperApp::get_steps()[$key_step_prev] : null;

                        if ($step_prev) {
                            if (!$analysis_patient->$step_prev) {
                                return [
                                    "status" => false,
                                    "message" => __("messages.Record the previous stage"),
                                ];
                            }
                        }
                    }
                }
            }
        }





        return [
            "status" => true,

        ];
    }


    public function report($id, $step)
    {
        $analysis_patient =  AnalysisPatient::where("type", "test_group")->where("id", $id)->first();
        if (!in_array($step, ['step_1', 'step_2', 'step_3', 'step_4', 'step_5', 'step_6_freezings', 'step_6_thawings', 'step_7']) || !$analysis_patient) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_NOT_FOUND, __("messages.Notfound"));
        }

        $data = null;

        if ($step == "step_4") {
            $data =  Step4Resource::collection($analysis_patient->step_4_all);
        } elseif ($step == "step_6_freezings") {
            $data = new Step6Resource($analysis_patient->step_6_freezings);
        } elseif ($step == "step_6_freezings") {
            $data = new Step6_2Resource($analysis_patient->step_6_thawings);
        } else {
            $step_number = explode("_", $step);
            $step_number = $step_number[1];

            $calss = "App\Http\Resources\TestGroup\Step" . $step_number . "Resource";
            $data = $analysis_patient->$step;
            if ($data) {
                $data = new $calss($data);
            }
        }

        return ResponseHelper::sendResponseSuccess($data);
    }

    public function previous_stage($id)
    {
        $analysis_patient =  AnalysisPatient::where("type", "test_group")->where("id", $id)->first();
        if (!$analysis_patient) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.Notfound'));
        }

        $step_now = HelperApp::get_step_data($analysis_patient)['step_now'];
        if ($step_now) {
            $step_number = array_flip(HelperApp::get_steps())[$step_now];


            if (in_array($step_number, [4, 5, 6, 7, 8, 9])) {
                $step_number = 4;
            } elseif ($step_number > 9) {
                if ($step_number == "13") {
                    $step_number = 7;
                } else {
                    if ($step_number == 12) {
                        $step_number = "6_2";
                    } else {
                        $step_number = $step_number - 5;
                    }
                }
            }

            $calss = "App\Http\Resources\TestGroup\Step" . $step_number . "Resource";
            $data = $analysis_patient->$step_now;

            return ResponseHelper::sendResponseSuccess(new $calss($data));
        }
    }


    public function get_report_by_step($step)
    {

        if (!in_array($step, ['step_1', 'step_2', 'step_3', 'step_4', 'step_5', 'step_6_freezings', 'step_6_thawings', 'step_7'])) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_NOT_FOUND, __("messages.Notfound"));
        }



        $data = AnalysisPatient::where("type", "test_group")->orderBy('id', 'desc')
            ->when(request('key_words'), function ($q) {
                $q->whereHas("patient",  function ($q) {
                    $q->where("name", "like", "%" . request('key_words') . "%")
                        ->orWhere("other_name", "like", "%" . request('key_words') . "%")
                        ->orWhere("other_medical_file_number", "like", "%" . request('key_words') . "%")
                        ->orWhere("medical_file_number", "like", "%" . request('key_words') . "%");
                });
            })->when(request('from_date'), function ($q) {
                $q->where("date", ">=", request('from_date'));
            })
            ->when(request('to_date'), function ($q) {
                $q->where("date", "<=", request('to_date'));
            });

        $data = $this->filter_step($step, $data);

        $data  =   $data->with(['patient', 'doctor'])->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(TestGroupResource::collection($data)->response()->getData());
    }
    private function filter_step($step, $q)
    {
        // if($step == "full"){
        //     return $q->whereHas('step_7');
        // }elseif($step == "step_1"){
        //     return $q->doesntHave('step_1');
        // }elseif($step == "step_6_freezings"){
        //     return $q->doesntHave("step_6_freezings")->whereHas("step_5");
        // }elseif($step == "step_6_thawings"){
        //     return $q->doesntHave("step_6_thawings")->whereHas("step_6_freezings");
        // }elseif($step == "step_7"){
        //     return $q->doesntHave("step_7")->whereHas("step_6_thawings");
        // } elseif($step == "step_5"){
        //     return $q->doesntHave("step_5")->whereHas("step_4_day_6");
        // }else{

        //     $prev_step = explode("_" , $step);
        //     $prev_step = end($prev_step) - 1;
        //     $prev_step = "step_". $prev_step;

        //     if($step == "step_4"){
        //         $step = "step_4_day_6";
        //     }
        //     return $q->doesntHave($step)->whereHas($prev_step);
        // }
        $steps = ['step_1', 'step_2', 'step_3', 'step_4', 'step_5', 'step_6_freezings', 'step_6_thawings', 'step_7'];

        if ($step == "step_1") {
            return $q;
        } elseif ($step == "step_4") {

            return  $q->where(function ($q) {
                $q->whereHas("step_3")->orWhereHas("step_4_complete");
            });
        } elseif ($step == "step_5") {

            return  $q->where(function ($q) {
                $q->whereHas("step_5")->orWhereHas("step_4_complete");
            });
        } else {

            $steps_flip = array_flip($steps);
            $prev_step_index = $steps_flip[$step] - 1;

            $prev_step = $steps[$prev_step_index];

            return  $q->where(function ($q) use ($prev_step, $step) {
                $q->whereHas($prev_step)->orWhereHas($step);
            });
        }


        // if ($step == "step_1") {
        //     return $q;
        // } elseif ($step == "step_7") {
        //     $q->whereHas("step_1")->orWhereHas("step_2");
        // }  elseif ($step == "step_2") {
        //     $q->whereHas("step_1")->orWhereHas("step_2");
        // } elseif ($step == "step_3") {
        //     $q->whereHas("step_2")->orWhereHas("step_3");
        // } elseif ($step == "step_4") {
        //     $q->whereHas("step_3")->orWhereHas("step_4_complete");
        // } elseif ($step == "step_5") {
        //     $q->whereHas("step_4_complete")->orWhereHas("step_5");
        // } elseif ($step == "step_5") {
        //     $q->whereHas("step_4_complete")->orWhereHas("step_5");
        // }
    }
}
