<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\StoreQtyRequest;
use App\Http\Requests\Api\StoreRequest;
use App\Http\Resources\StoreReportResource;
use App\Http\Resources\StoreResource;
use App\Models\Store;
use App\Models\StoreReport;
use Illuminate\Http\Request;

class StoreController extends Controller
{

    public function index(){
        $data = Store::orderBy("id" , "desc")->when(request('key_words') , function($q){
            $q->where('name' , 'like' , '%'.request('key_words').'%');
        })->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(StoreResource::collection($data)->response()->getData());
    }
    public function create(StoreRequest $request){
        $data = $request->validated();
        $data['user_id']=auth('api')->id();
        Store::create($data);
        return ResponseHelper::sendResponseSuccess();
    }

    public function update_qty(StoreQtyRequest $request){
        $item  = Store::find($request->id);
        $new_qty_request = $request->new_qty;

        if($item->qty == $new_qty_request){
            return ResponseHelper::sendBadRequest(__("messages.It is not possible to update for the same quantity"));
        }
        $action =   $new_qty_request  > $item->qty ? "plus" : "minus";
        if($action == "plus"){
            $action_qty = $new_qty_request - $item->qty;
        }else{
            $action_qty = $item->qty - $new_qty_request;
        }

        $data = [
            "store_id"=>$request->id,
            "old_qty"=>$item->qty,
            "new_qty"=>$new_qty_request,
            "action_qty"=>$action_qty,
            "action"=>$action,
            "user_id"=>auth('api')->id(),
            "report"=>$request->report
        ];

        $item->qty = $new_qty_request;
        $item->save();
        StoreReport::create($data);
        return ResponseHelper::sendResponseSuccess();


    }

    public function report($id){
        $data = StoreReport::where("store_id" , $id)->with('store')->orderBy("id" , "desc")->paginate(config('app.paginate_number'));
        return ResponseHelper::sendResponseSuccess(StoreReportResource::collection($data)->response()->getData());

    }
}
