<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class StatisticsUserController extends Controller
{

    private $kpisController;
    public  function __construct()
    {
        $this->kpisController = new KPIController();
    }


    public function statistics($patinet_id)
    {








        return [

            "data" => [
                $this->fertilization_rate($patinet_id),
                $this->maturation_rate($patinet_id),
                $this->immaturation_rate($patinet_id),
                $this->abnormality_rate($patinet_id),
                $this->cleavage_rate($patinet_id),
                $this->blastocyst_formation_rate($patinet_id),
            ]


        ];
    }

    //نسبة البيوض المخصبة
    public function fertilization_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_fertilized_eggs_on_the_first_day_is_2pn($patinet_id), $this->kpisController->number_of_mature_eggs($patinet_id));
        return [
            [
                "title" => __("messages.Number of fertilized eggs"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" => __("messages.Number of mature eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // نسبة البيوض الناضجة
    public function maturation_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_mature_eggs($patinet_id), $this->kpisController->number_of_eggs_all($patinet_id));
        return [
            [
                "title" => __("messages.Number of mature eggs"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" => __("messages.Total number of eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }

    // نسبة البيوض الغير ناضجة
    public function immaturation_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_eggs_all($patinet_id), $this->kpisController->number_of_mature_eggs($patinet_id));
        return [
            [
                "title" => __("messages.Total number of eggs"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" => __("messages.Number of mature eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // نسبة البيوض المشوهة
    public function abnormality_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_abnormal_eggs($patinet_id), $this->kpisController->number_of_eggs_all($patinet_id));
        return [
            [
                "title" => __("messages.Number of abnormal eggs"),

                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" => __("messages.Total number of eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // نسبة انقسام الاجنة
    public function cleavage_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->total_number_of_embryos_on_the_second_day($patinet_id), $this->kpisController->number_of_fertilized_eggs_is_2pn($patinet_id));
        return [
            [
                "title" => __("messages.Number of embryos"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" =>  __("messages.Number of fertilized eggs 2pn"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }

    // نسبة تكوين البلاست
    public function blastocyst_formation_rate($patinet_id)
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_blastocysts($patinet_id), $this->kpisController->number_of_fertilized_eggs_is_2pn($patinet_id));
        return [
            [
                "title" =>  __("messages.Number of blastocyst"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            [
                "title" =>  __("messages.Number of fertilized eggs 2pn"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    private function statistics_calc($count_1, $count_2)
    {

        $count_2 =  $count_2 == 0 ? 1 : $count_2;

        $percentage_1 =  ($count_1 / $count_2) * 100;
        $percentage_2 = 100 - $percentage_1;
        return [
            "percentage_1" => $percentage_1,
            "percentage_1_text" => number_format($percentage_1, 2) . " %",
            "percentage_2" => $percentage_2,
            "percentage_2_text" => number_format($percentage_2, 2) . " %",
        ];
    }
}
