<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Patient;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Models\AnalysisPatient;

class StatisticsController extends Controller
{

    private $kpisController;
    public  function __construct()
    {
        $this->kpisController = new KPIController();
    }

    public function home_counts()
    {
        $patient_day_count = Patient::whereMonth('created_at', now()->month)->whereYear('created_at', date('Y'))->whereDay('created_at', now()->day)->count();
        $patient_month_count = Patient::whereMonth('created_at', now()->month)->whereYear('created_at', date('Y'))->count();
        $analysis_day_count = AnalysisPatient::whereMonth('created_at', now()->month)->whereYear('created_at', date('Y'))->whereDay('created_at', now()->day)->count();
        $analysis_month_count = AnalysisPatient::whereMonth('created_at', now()->month)->whereYear('created_at', date('Y'))->count();

        $data =  [
            "patient_day_count" => [
                "title" => __("messages_301.Patients today"),
                "count" => $patient_day_count,
            ],
            "patient_month_count" => [
                "title" => __("messages_301.Patients this month"),
                "count" => $patient_month_count,
            ],
            "analysis_day_count" => [
                "title" => __("messages_301.Analysis today"),
                "count" => $analysis_day_count,
            ],
            "analysis_month_count" => [
                "title" => __("messages_301.Analysis this month"),
                "count" => $analysis_month_count,
            ],

        ];
        return ResponseHelper::sendResponseSuccess($data);
    }

    public function statistics()
    {

        $data =  [
            "pregnancy_rate" => $this->pregnancy_rate(),
            "fet_pregnancy_rate" => $this->fet_pregnancy_rate(),
            "miscarriage_rate" => $this->miscarriage_rate(),
            "fertilization_rate_of_embryos" => $this->fertilization_rate_of_embryos(),
            "blastocyst_formation_rate" => $this->blastocyst_formation_rate(),
            "cleavage_rate" => $this->cleavage_rate(),
            "degeneration_rate_after_icsi" => $this->degeneration_rate_after_icsi(),
            "live_birth_rate" => $this->live_birth_rate(),
        ];
        return ResponseHelper::sendResponseSuccess($data);
    }

    private function statistics_calc($count_1, $sum)
    {

        $sum =  $sum == 0 ? 1 : $sum;

        $percentage_1 =  ($count_1 / $sum) * 100;
        $percentage_2 = 100 - $percentage_1;
        return [
            "percentage_1" => $percentage_1,
            "percentage_1_text" => number_format($percentage_1, 2) . " %",
            "percentage_2" => $percentage_2,
            "percentage_2_text" => number_format($percentage_2, 2) . " %",
        ];
    }
    //معدل الحمل
    private function pregnancy_rate()
    {


        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_pregnancies_after_embryo_transfer(), $this->kpisController->total_number_of_cases_after_embryo_return());
        return [
            "number_of_pregnancies_after_embryo_transfer" => [
                "title" => __("messages.Number of pregnancies after embryo transfer"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "total_number_of_cases_after_embryo_return" => [
                "title" => __("messages.Total number of pregnancies after embryo transfer"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }

    private function live_birth_rate()
    {


        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_live_birth(), $this->kpisController->number_of_total_pregnancies());
        return [
            "number_of_live_birth" => [
                "title" => __("messages.Number of birth live"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_total_pregnancies" => [
                "title" => __("messages.Total number of pregnancies"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // معدل الحمل بالأجنة المجمدة
    private function fet_pregnancy_rate()
    {


        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_pregnancies_after_return_of_frozen_embryos(), $this->kpisController->total_number_of_cases_after_return_of_frozen_embryos());
        return [
            "number_of_pregnancies_after_return_of_frozen_embryos" => [
                "title" => __("messages.Number of pregnancies after return of frozen embryo"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "total_number_of_cases_after_return_of_frozen_embryos" => [
                "title" => __("messages.Total number of pregnancies after return of frozen embryo"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }

    //معدل الإجهاض

    private function miscarriage_rate()
    {
        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_miscarriages(), $this->kpisController->number_of_total_pregnancies());
        return [
            "number_of_miscarriages" => [
                "title" => __("messages.Number of miscarriages"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_total_pregnancies" => [
                "title" => __("messages.Total number of pregnancies"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    //	معدلات التخصيب للاجنة
    private function fertilization_rate_of_embryos()
    {

        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_successfully_fertilized_eggs(), $this->kpisController->number_of_mature_eggs());
        return [
            "number_of_successfully_fertilized_eggs" => [
                "title" => __("messages.Number of successfull fertilized eggs"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_mature_eggs" => [
                "title" => __("messages.Number of mature eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // معدل تكوين البلاست
    private function blastocyst_formation_rate()
    {




        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_blastocysts(), $this->kpisController->number_of_fertilized_eggs_is_2pn());
        return [
            "number_of_blastocysts" => [
                "title" => __("messages.Number of blastocyst"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_fertilized_eggs_is_2pn" => [
                "title" => __("messages.Number of fertilized eggs 2pn"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }


    // 7-	معدل انقسام الاجنة






    private function cleavage_rate()
    {




        $statistics_calc =  $this->statistics_calc($this->kpisController->total_number_of_embryos_on_the_second_day(), $this->kpisController->number_of_fertilized_eggs_on_the_first_day_is_2pn());
        return [
            "total_number_of_embryos_on_the_second_day" => [
                "title" => __("messages.Sum of embryos in the second day"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_fertilized_eggs_on_the_first_day_is_2pn" => [
                "title" => __("messages.Number of embryos in the first day 2pn"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }



    // معدل تلف  البيوض  بعد  الحقن
    private function degeneration_rate_after_icsi()
    {







        $statistics_calc =  $this->statistics_calc($this->kpisController->number_of_damaged_eggs(), $this->kpisController->number_of_eggs_injected());
        return [
            "number_of_damaged_eggs" => [
                "title" => __("messages.Number of damaged eggs"),
                "percentage" => $statistics_calc["percentage_1"],
                "percentage_text" => $statistics_calc["percentage_1_text"],
            ],
            "number_of_eggs_injected" => [
                "title" =>  __("messages.Number of injected eggs"),
                "percentage" => $statistics_calc["percentage_2"],
                "percentage_text" => $statistics_calc["percentage_2_text"],
            ]
        ];
    }
}
