<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use App\Models\QMLabEnvironment;
use App\Models\QMHeatedIncubator;
use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperData;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\QualityNotifyRequest;
use App\Models\QMAirPurifiersDevice;
use App\Models\QMGeneralLabCleaning;
use App\Models\QMIncubatorQualityControlLog;
use App\Models\QMTankLiquidNitrogenLevelCheck;
use App\Models\QMCo2AndN2CylinderGasLevelCheck;
use App\Models\QMMicromanipulatorAndIcsiStation;
use App\Models\QMIncubatorQualityControlLogBenchtop;
use App\Models\QMWorkstationsAndLaminarFlowCabinets;

class QualityManagementNotifyController extends Controller
{
    //
    public function notify(QualityNotifyRequest $request)
    {

        $models = [
            [
                "name" => "Incubator Quality Control Log",
                "class" => QMIncubatorQualityControlLog::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Incubator Quality Control Log Benchtop",
                "class" => QMIncubatorQualityControlLogBenchtop::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Heated Incubator",
                "class" => QMHeatedIncubator::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Workstations and Laminar Flow Cabinets",
                "class" => QMWorkstationsAndLaminarFlowCabinets::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Micromanipulator & icsi station",
                "class" => QMMicromanipulatorAndIcsiStation::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Air Purifiers device",
                "class" => QMAirPurifiersDevice::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Co2 & N2 Cylinder gas level check",
                "class" => QMCo2AndN2CylinderGasLevelCheck::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Tank Liquid nitrogen level check",
                "class" => QMTankLiquidNitrogenLevelCheck::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "Lab Environment",
                "class" => QMLabEnvironment::class,
                "field" => "next_cleaning_date",
            ],
            [
                "name" => "General Lab cleaning",
                "class" => QMGeneralLabCleaning::class,
                "field" => "next_cleaning_date",
            ],

        ];
        $data = [];

        foreach ($models as $model) {
            // helper data
            $model_data = HelperData::get_notify($model['class'], $model['field'] , $request->date);
            if ($model_data) {
                $data[] = [
                    "title" => $model['name'],
                    "next_cleaning_date" => $model_data->next_cleaning_date,
                ];
            }
        }

        return ResponseHelper::sendResponseSuccess($data);
    }
}
