<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\DeviceTypeEnum;
use App\Http\Requests\Api\QualityManagement\IncubatorQualityControlLogRequest;
use App\Http\Requests\Api\QualityManagement\IncubatorQualityControlLogBenchtopRequest;
use App\Http\Requests\Api\QualityManagement\HeatedIncubatorRequest;
use App\Http\Requests\Api\QualityManagement\WorkstationsAndLaminarFlowCabinetsRequestUpdate;
use App\Http\Requests\Api\QualityManagement\MicromanipulatorAndIcsiStationRequest;
use App\Http\Requests\Api\QualityManagement\AirPurifiersDeviceRequestUpdate;
use App\Http\Requests\Api\QualityManagement\AirPurifiersDeviceRequestCreate;
use App\Http\Requests\Api\QualityManagement\Co2AndN2CylinderGasLevelCheckRequest;
use App\Http\Requests\Api\QualityManagement\TankLiquidNitrogenLevelCheckRequest;
use App\Http\Requests\Api\QualityManagement\LabEnvironmentRequest;
use App\Http\Requests\Api\QualityManagement\RefrigeratorsTemperatureLogRequest;
use App\Http\Requests\Api\QualityManagement\GeneralLabCleaningRequest;
use App\Http\Requests\Api\QualityManagement\WorkstationsAndLaminarFlowCabinetsRequestCreate;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\QualityManagement\Co2AndN2CylinderGasLevelCheckRequestCreate;
use App\Http\Requests\Api\QualityManagement\Co2AndN2CylinderGasLevelCheckRequestUpdate;
use App\Http\Requests\Api\QualityManagement\GeneralLabCleaningRequestUpdate;
use App\Http\Requests\Api\QualityManagement\RefrigeratorsTemperatureLogRequestUpdate;
use App\Http\Requests\Api\QualityManagement\TankLiquidNitrogenLevelCheckRequestCreate;
use App\Http\Requests\Api\QualityManagement\TankLiquidNitrogenLevelCheckRequestUpdate;
use App\Models\Device;
use App\Models\QMAirPurifiersDevice;
use App\Models\QMAirPurifiersDeviceData;
use App\Models\QMChamper;
use App\Models\QMCo2AndN2CylinderGasLevelCheck;
use App\Models\QMCo2AndN2CylinderGasLevelCheckData;
use App\Models\QMGeneralLabCleaning;
use App\Models\QMHeatedIncubator;
use App\Models\QMIncubatorQualityControlLog;
use App\Models\QMIncubatorQualityControlLogBenchtop;
use App\Models\QMLabEnvironment;
use App\Models\QMMicromanipulatorAndIcsiStation;
use App\Models\QMRefrigeratorsTemperatureLog;
use App\Models\QMTankLiquidNitrogenLevelCheck;
use App\Models\QMTankLiquidNitrogenLevelCheckData;
use App\Models\QMWorkstationsAndLaminarFlowCabinets;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Schema;
class QualityManagementController extends Controller
{

    public function devices($type)
    {

        $devices = Device::where("type" , $type)->select("id"  , "name" , "type")->get();
        return ResponseHelper::sendResponseSuccess( $devices );
    }

    public function types(Request $request)
    {
        return ResponseHelper::sendResponseSuccess(DeviceTypeEnum::values());
    }

    public function data($type)
    {


        if(!in_array($type, DeviceTypeEnum::values())){
            return ResponseHelper::sendResponseError(null , Response::HTTP_NOT_FOUND , __('messages.Notfound'));
        }

        $type_clean = $type;
        $type = $this->snake_to_camel($type);
        $model = "App\Models\QM$type" ;
        $resource = "App\Http\Resources\QualityManagement\\".$type."Resource";
        $model_instance = new $model;



        $data =  $model::query();


        $list_column = Schema::getColumnListing($model_instance->getTable());

        if(in_array("device_id"  , $list_column)){

            $data = $data->when(request('key_words') , function($q){

                $q->whereHas('device' , function($q){

                    $q->where('name' , 'like' , '%'.request('key_words').'%');
                });
            });
        }elseif($type_clean == "general_lab_cleaning" && request('key_words')){

            $data = $data->where("general_lab_cleaning" , request('key_words'));
        }elseif($type_clean == "lab_environment"){

            if(request('from_date')){
                $data = $data->whereDate("created_at" , ">=" , request('from_date'));
            }

            if(request('to_date')){
                $data = $data->whereDate("created_at" , "<=" , request('to_date'));
            }
        }

        $data =   $data->orderBy('created_at','desc')->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess($resource::collection($data)->response()->getData());

    }



    function snake_to_camel($string) {
        // Split the string by underscores
        $words = explode('_', $string);

        // Capitalize the first letter of each word
        $words = array_map('ucfirst', $words);

        // Combine the words back into a single string
        return implode('', $words);
    }
    public function incubator_quality_control_log(IncubatorQualityControlLogRequest $request)
    {
        $get_data = $this->get_data($request , QMIncubatorQualityControlLog::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMIncubatorQualityControlLog::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }



    public function incubator_quality_control_log_benchtop(IncubatorQualityControlLogBenchtopRequest $request)
    {

        $get_data = $this->get_data($request , QMIncubatorQualityControlLogBenchtop::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }



        $model_update = $get_data['model_update'];
        if($model_update){
            QMChamper::where("qm_incubator_quality_control_log_benchtop_id" , $model_update->id)->delete();
            $id  = $model_update->id;
            $model_update->update($get_data['data']);
        }else{

            $item = QMIncubatorQualityControlLogBenchtop::create($get_data['data']);
            $id  = $item->id;
        }



        if($request->champers && count($request->champers)){
            $champers =[];
            foreach($request->champers  as $champer){
                $champers[]=[
                    "qm_incubator_quality_control_log_benchtop_id"=> $id,
                    "lid"=>$champer['lid'],
                    "bottom"=>$champer['bottom'],
                ];
            }

            QMChamper::insert($champers);
        }


        return ResponseHelper::sendResponseSuccess(null);
    }

    public function heated_incubator(HeatedIncubatorRequest $request)
    {
        $get_data = $this->get_data($request , QMHeatedIncubator::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMHeatedIncubator::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }



    public function workstations_and_laminar_flow_cabinets_create(WorkstationsAndLaminarFlowCabinetsRequestCreate $request)
    {

        $data=[];

        foreach($request->laminars as $laminar){
            $check_device = $this->check_device($laminar['device_id']  , "workstations_and_laminar_flow_cabinets");
            if(!$check_device['status']){
                return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , $check_device['message']);
            }

            $data[]=[
                "device_id"=>$laminar['device_id'],
                "user_id"=>auth('api')->id(),
                "heating_stage_temperature"=>$laminar['heating_stage_temperature'],
                "filter_installation_date"=>$laminar['filter_installation_date'],
                "cleaning_date"=>$laminar['cleaning_date'],
                "next_cleaning_date"=>$laminar['next_cleaning_date'],
                "report"=>$laminar['report'],
                "evaluation"=>$laminar['evaluation'],
                "created_at"=>Carbon::now(),
            ];
        }




        QMWorkstationsAndLaminarFlowCabinets::insert($data);



        return ResponseHelper::sendResponseSuccess(null);
    }



    public function workstations_and_laminar_flow_cabinets_update(WorkstationsAndLaminarFlowCabinetsRequestUpdate $request)
    {
        $get_data = $this->get_data($request , QMWorkstationsAndLaminarFlowCabinets::class , "workstations_and_laminar_flow_cabinets");
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMWorkstationsAndLaminarFlowCabinets::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }

    public function micromanipulator_and_icsi_station(MicromanipulatorAndIcsiStationRequest $request)
    {
        $get_data = $this->get_data($request , QMMicromanipulatorAndIcsiStation::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMMicromanipulatorAndIcsiStation::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }

    public function air_purifiers_device_create(AirPurifiersDeviceRequestCreate $request)
    {


        $devices =[];
        foreach($request->devices as $device){
            $check_device = $this->check_device($device['device_id']  , "air_purifiers_device");
            if(!$check_device['status']){
                return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , $check_device['message']);
            }
            $devices[]=[
                "user_id"=>auth('api')->id(),
                "device_id"=>$device['device_id'],
                "evaluation"=>$device['evaluation'],
                "next_cleaning_date"=>$device['next_cleaning_date'],
                "report"=>$device['report'],
              //  "device_name_or_id"=>$device["device_name_or_id"],
                "installation_date"=>$device["installation_date"],
                "next_change_date"=>$device["next_change_date"],
                "pre_filters_date_install"=>$device["pre_filters_date_install"],
                "pre_filters_date_change"=>$device["pre_filters_date_change"],
                "carbon_filters_date_install"=>$device["carbon_filters_date_install"],
                "carbon_filters_date_change"=>$device["carbon_filters_date_change"],
                "ulpa_filters_date_install"=>$device["ulpa_filters_date_install"],
                "ulpa_filters_date_change"=>$device["ulpa_filters_date_change"],
                "hepa_filters_date_install"=>$device["hepa_filters_date_install"],
                "hepa_filters_date_change"=>$device["hepa_filters_date_change"],
                "created_at"=>Carbon::now()
            ];
        }

        QMAirPurifiersDevice::insert($devices);

        return ResponseHelper::sendResponseSuccess(null);


    }


    public function air_purifiers_device_update(AirPurifiersDeviceRequestUpdate $request)
    {
        $get_data = $this->get_data($request , QMAirPurifiersDevice::class , "air_purifiers_device");
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }


        $get_data['model_update']->update($get_data['data']);



        return ResponseHelper::sendResponseSuccess(null);


    }

    public function co2_and_n2_cylinder_gas_level_check_create(Co2AndN2CylinderGasLevelCheckRequestCreate $request)
    {


        $cylinders =[];
        foreach($request->cylinders as $cylinder){
            $check_device = $this->check_device($cylinder['device_id']  , "co2_and_n2_cylinder_gas_level_check");
            if(!$check_device['status']){
                return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , $check_device['message']);
            }
            $cylinders[]=[
                "device_id"=>$cylinder["device_id"],
                "user_id"=>auth('api')->id(),
                "next_cleaning_date"=>$cylinder["next_cleaning_date"],
                "date_time"=>$cylinder["date_time"],
                // "cylinder_no"=>$cylinder["cylinder_no"],
                "co2_level"=>$cylinder["co2_level"],
                "n2_level"=>$cylinder["n2_level"],
                //"check_by"=>$cylinder["check_by"],
                "created_at"=>Carbon::now()

            ];
        }

        QMCo2AndN2CylinderGasLevelCheck::insert($cylinders);

        return ResponseHelper::sendResponseSuccess(null);
    }


    public function co2_and_n2_cylinder_gas_level_check_update(Co2AndN2CylinderGasLevelCheckRequestUpdate $request)
    {

        $get_data = $this->get_data($request , QMCo2AndN2CylinderGasLevelCheck::class , "co2_and_n2_cylinder_gas_level_check");
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }


        $get_data['model_update']->update($get_data['data']);



        return ResponseHelper::sendResponseSuccess(null);

    }

    public function tank_liquid_nitrogen_level_check_create(TankLiquidNitrogenLevelCheckRequestCreate $request)
    {


        $tanks =[];








        foreach($request->tanks as $tank){
            $check_device = $this->check_device($tank['device_id']  , "tank_liquid_nitrogen_level_check");
            if(!$check_device['status']){
                return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , $check_device['message']);
            }
            $tanks[]=[
                "device_id"=>$tank["device_id"],
                "user_id"=>auth('api')->id(),
                "next_cleaning_date"=>$tank["next_cleaning_date"],
                "date_time"=>$tank["date_time"],
                "date_time"=>$tank["date_time"],
               // "tank_number_or_name"=>$tank["tank_number_or_name"],
                "liquid_n2_level"=>$tank["liquid_n2_level"],
               // "check_by"=>$tank["check_by"],
                "created_at"=>Carbon::now(),

            ];
        }

        QMTankLiquidNitrogenLevelCheck::insert($tanks);

        return ResponseHelper::sendResponseSuccess(null);
    }




    public function tank_liquid_nitrogen_level_check_update(TankLiquidNitrogenLevelCheckRequestUpdate $request)
    {
        $get_data = $this->get_data($request , QMTankLiquidNitrogenLevelCheck::class , "tank_liquid_nitrogen_level_check");
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        $model_update = $get_data['model_update'];
        $model_update->update($get_data['data']);
        return ResponseHelper::sendResponseSuccess(null);
    }

    public function lab_environment(LabEnvironmentRequest $request)
    {
        $get_data = $this->get_data($request , QMLabEnvironment::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMLabEnvironment::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }

    public function refrigerators_temperature_log(RefrigeratorsTemperatureLogRequest $request)
    {
        $data = [];



        foreach($request->items as $item){
            $check_device = $this->check_device($item['device_id']  , "refrigerators_temperature_log");

            if(!$check_device['status']){
                return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , $check_device['message']);
            }

            $data[] = [
                "user_id"=>auth('api')->id(),
                "date_time"=>$item['date_time'],
                "shift"=>$item['shift'],
                "device_id"=>$item['device_id'],
                "temperature"=>$item['temperature'],
                "report"=>$item['report'],
                "created_at"=>Carbon::now(),
                "updated_at"=>Carbon::now()
            ];
        }

        QMRefrigeratorsTemperatureLog::insert($data);
        return ResponseHelper::sendResponseSuccess(null);
    }


    public function refrigerators_temperature_log_update(RefrigeratorsTemperatureLogRequestUpdate $request)
    {
        $get_data = $this->get_data($request , QMRefrigeratorsTemperatureLog::class , "refrigerators_temperature_log");
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        $model_update = $get_data['model_update'];
        $model_update->update($get_data['data']);
        return ResponseHelper::sendResponseSuccess(null);
    }


    public function general_lab_cleaning(GeneralLabCleaningRequest $request)
    {
        $data = [];


        foreach($request->items as $item){
            $data[] = [
                "user_id"=>auth('api')->id(),
                "general_lab_cleaning"=>$item['general_lab_cleaning'],
                "cleaning_date" => $item['cleaning_date'],
                "cleaned_by" => $item['cleaned_by'],
                "next_cleaning_date" => $item['next_cleaning_date'],
                "report" => $item['report'],
                "created_at" => Carbon::now(),
            ];
        }

        QMGeneralLabCleaning::insert($data);
        return ResponseHelper::sendResponseSuccess(null);
    }

    public function general_lab_cleaning_update(GeneralLabCleaningRequestUpdate $request)
    {
        $get_data = $this->get_data($request , QMGeneralLabCleaning::class , __FUNCTION__);
        if(!$get_data['status']){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , $get_data['message']);
        }

        if($get_data['model_update']){
            $model_update = $get_data['model_update'];
            $model_update->update($get_data['data']);
        }else{
            QMGeneralLabCleaning::create($get_data['data']);
        }



        return ResponseHelper::sendResponseSuccess(null);
    }

    private function get_data($request , $model , $type){

        $model_update = null;
        if($request->id){
            $check = $model::where("id" , $request->id)->first();

            if(!$check){
                return [
                    "status"=>false,
                    "message"=>__('messages.Notfound')
                ];
            }

            $model_update  =    $check;
        }
        $check_device = $this->check_device($request->device_id , $type);
        if(!$check_device['status']){
            return [
                "status"=>false,
                "message"=>$check_device['message']
            ];
        }

        $data= $request->validated();
        $data['user_id']=auth('api')->id();
        return [
            "status"=>true,
            "data"=>$data,
            "model_update"=>$model_update,
        ];

    }

    private function set_data(){

    }


    private function check_device($device_id , $type){


        if($device_id ){

            $device = Device::where("id" , $device_id )->where("type" , $type)->first();
            if(!$device){
                return [
                    "status"=>false,
                    "message"=>__("messages.Device not found")
                ];

            }
        }

        return [
            "status"=>true,
        ];

    }
}
