<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Throwable;
use App\Models\Pgd;
use Faker\Extension\Helper;
use Illuminate\Http\Request;
use App\Models\PgdAttachment;
use Illuminate\Http\Response;
use App\Http\Helpers\HelperApp;
use App\Models\AnalysisPatient;
use App\Http\Helpers\HelperFile;
use Illuminate\Support\Facades\DB;
use App\Http\Resources\PgdResource;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\PgdRequest;
use App\Http\Requests\Api\PgdUpdateRequest;

class PgdController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Pgd::with('analysis_patient', 'patient', 'attachments')->orderBy('id', 'desc')->paginate(config('app.paginate_number'));
        return ResponseHelper::sendResponseSuccess(PgdResource::collection($data)->response()->getData());
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PgdRequest $request)
    {
        //
        DB::beginTransaction();
        try {
            if (!$this->check_type("pgd")) {
                return ResponseHelper::sendNotFound(__('messages.Notfound'));
            }
            $data = $request->validated();
            $data['user_id'] = auth('api')->id();

            $pgd = Pgd::create($data);
            $attachment_data = $this->get_embyro_data($pgd->id, $request);
            PgdAttachment::insert($attachment_data);
            DB::commit();
            return ResponseHelper::sendResponseSuccess(new PgdResource($pgd));
        } catch (Throwable $e) {

            DB::rollBack();
            HelperApp::set_log_catch('Create PGD', $e->getMessage());
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //

        $data = Pgd::with('analysis_patient', 'patient', 'attachments')->where('analysis_patient_id', $id)->first();
        if (!$data) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_NOT_FOUND, __('messages.Notfound'));
        }
        return ResponseHelper::sendResponseSuccess(new PgdResource($data));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(PgdUpdateRequest $request)
    {
        $pgd =  Pgd::findOrFail($request->id);


        DB::beginTransaction();
        try {


            if (!$this->check_type("pgd")) {
                return ResponseHelper::sendNotFound(__('messages.Notfound'));
            }
            // update base data
            $pgd_data = $request->validated();
            $pgd_data['user_id'] = auth('api')->id();
            $pgd->update($pgd_data);

            $data = [];

            $new_ids = collect($request->embyro)->pluck('id')->toArray();
            foreach ($request->embyro as $item) {


                if (isset($item['id']) && $item['id']) {
                    $item_db = PgdAttachment::find($item['id']);
                    $image_path = $item_db->image;
                    if (isset($item['image']) && $item['image']) {
                        HelperFile::delete($item_db->image);
                        $image_path = HelperFile::upload($item['image'], 'embyro')['path'];
                    }
                    $data[] = [
                        "image" => $image_path,
                        "pgd_id" => $request->id,
                        "name" => $item['name'],
                    ];
                } else {
                    $data[] = [
                        "image" => HelperFile::upload($item['image'], 'embyro')['path'],
                        "pgd_id" => $request->id,
                        "name" => $item['name'],
                    ];
                }
            }


            $old_images = PgdAttachment::whereNotIn('id', $new_ids)->pluck('image')->toArray();
            foreach ($old_images as $img) {
                HelperFile::delete($img);
            }
            PgdAttachment::where('pgd_id', $request->id)->delete();
            PgdAttachment::insert($data);
            DB::commit();
            return ResponseHelper::sendResponseSuccess(new PgdResource($pgd));
        } catch (Throwable $e) {
            DB::rollBack();
            HelperApp::set_log_catch('Update PGD', $e->getMessage());
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        $data = Pgd::with('patient', 'attachments')->where('id', $id)->first();
        if (!$data) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_NOT_FOUND, __('messages.Notfound'));
        }
        $attachments = PgdAttachment::where('pgd_id', $id)->pluck('image')->toArray();
        foreach ($attachments as $img) {
            HelperFile::delete($img);
        }
        // PgdAttachment::where('pgd_id', $id)->delete();
        $data->delete();
        return ResponseHelper::sendResponseSuccess();
    }

    private function get_embyro_data($id, $request)
    {
        $data = [];
        foreach ($request->embyro as $item) {
            $data[] = [
                "pgd_id" => $id,
                'image' => HelperFile::upload($item['image'], 'embyro')['path'],
                'name' => $item['name'],
            ];
        }

        return $data;
    }


    private function check_type($type)
    {
        $analysis_patient = AnalysisPatient::withoutGlobalScope('notype')->find(request('analysis_patient_id'));
        if ($analysis_patient->general_analysis->type != $type) {
            return false;
        }
        return true;
    }
}
