<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperFile;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\PatientRequest;
use App\Http\Requests\Api\PregenantRequest;
use App\Http\Resources\AnalysisPatientResource;
use App\Http\Resources\PatientResource;
use App\Models\AnalysisPatient;
use App\Models\Patient;
use App\Models\PatientFile;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use function Laravel\Prompts\form;

class PatientController extends Controller
{
    public function previous_analysis($id)
    {
        $data = AnalysisPatient::with('general_analysis')->where('is_sample_received',  true)->where("patient_id", $id)->where("type", "general")->orderBy('id', 'desc')->paginate(config('app.paginate_number'));
        // $data = AnalysisPatient::with('general_analysis')->where('complete')->where('is_sample_received',  true)->where("patient_id", $id)->where("type", "general")->orderBy('id','desc')->paginate(config('app.paginate_number'));
        return ResponseHelper::sendResponseSuccess(AnalysisPatientResource::collection($data)->response()->getData());
    }
    /**
     * Display a listing of the resource.
     */


    public function index()
    {

        $patients = Patient::orderBy('id', 'desc')
            ->when(request('key_words'), function ($q) {
                $key_words = request('key_words');

                $q->where(function ($query) use ($key_words) {
                    $query->where("name", "like", "%{$key_words}%")
                        ->orWhere("occupation", "like", "%{$key_words}%")
                        ->orWhere("mobile", "like", "%{$key_words}%")
                        ->orWhere("place_of_residence", "like", "%{$key_words}%")
                        ->orWhere("id_number", "like", "%{$key_words}%")
                        ->orWhere("medical_file_number", "like", "%{$key_words}%")
                        ->orWhere("date_of_visit", "like", "%{$key_words}%")
                        ->orWhere("medical_history", "like", "%{$key_words}%")
                        ->orWhere("date_marriage", $key_words)

                        ->orWhere("other_name", "like", "%{$key_words}%")
                        ->orWhere("other_occupation", "like", "%{$key_words}%")
                        ->orWhere("other_mobile", "like", "%{$key_words}%")
                        ->orWhere("other_place_of_residence", "like", "%{$key_words}%")
                        ->orWhere("other_id_number", "like", "%{$key_words}%")
                        ->orWhere("other_medical_file_number", "like", "%{$key_words}%")
                        ->orWhere("other_date_of_visit", "like", "%{$key_words}%")
                        ->orWhere("other_medical_history", "like", "%{$key_words}%")


                        ->orWhere("age", $key_words)
                        ->orWhere("height", $key_words)
                        ->orWhere("other_age", $key_words)
                        ->orWhere("other_height", $key_words);
                });
            });
        if (request('from_date')) {
            $patients = $patients->where(function ($query) {
                $query->whereDate("date_of_visit", ">=", request('from_date'))
                    ->orWhere('other_date_of_visit', '>=', request('from_date'));
            });
        }

        if (request('to_date')) {
            $patients = $patients->where(function ($query) {
                $query->whereDate("date_of_visit", "<=", request('to_date'))
                    ->orWhere('other_date_of_visit', '<=', request('to_date'));
            });
        }
        $patients = $patients->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(['patients' => PatientResource::Collection($patients)->response()->getData()]);
    }




    /**
     * Show the form for creating a new resource.
     */
    public function create(PatientRequest $request)
    {
        $data = $request->validated();
        unset($data['attachments']);
        $patient = Patient::create($request->validated());

        $files = [];


        if ($request->attachments && count($request->attachments)) {

            foreach ($request->attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file, "patients")['path'],
                    "to" => "patient",
                    "patient_id" => $patient->id,
                ];
            }
        }


        if ($request->other_attachments && count($request->other_attachments)) {

            foreach ($request->other_attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file, "patients")['path'],
                    "to" => "other",
                    "patient_id" => $patient->id,
                ];
            }
        }

        if (count($files)) {
            PatientFile::insert($files);
        }

        return ResponseHelper::sendResponseSuccess(new PatientResource($patient), Response::HTTP_OK, __('messages.done successfully'));
    }



    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function update(PatientRequest $request, string $id)
    {
        $patient = Patient::where("id", $id)->first();
        if (!$patient) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.Notfound'));
        }

        $patient->update($request->validated());

        $files = [];


        if ($request->attachments && count($request->attachments)) {

            foreach ($request->attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file, "patients")['path'],
                    "to" => "patient",
                    "patient_id" => $patient->id,
                ];
            }
        }


        if ($request->other_attachments && count($request->other_attachments)) {

            foreach ($request->other_attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file, "patients")['path'],
                    "to" => "other",
                    "patient_id" => $patient->id,
                ];
            }
        }

        if (count($files)) {
            PatientFile::insert($files);
        }
        return ResponseHelper::sendResponseSuccess(new PatientResource($patient), Response::HTTP_OK, __('messages.done successfully'));
    }



    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $patient = Patient::where("id", $id)->first();
        if (!$patient) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.Notfound'));
        }

        $files = array_merge($patient->files->pluck('path')->toArray(), $patient->other_files->pluck('path')->toArray());

        foreach ($files as $file) {
            HelperFile::delete($file);
        }
        $patient->delete();
        return ResponseHelper::sendResponseSuccess(null, Response::HTTP_OK, __('messages.done successfully'));
    }


    public function destroy_file($id)
    {
        $file = PatientFile::where('id', $id)->first();
        if (!$file) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages.Notfound'));
        }

        HelperFile::delete($file->path);

        $file->delete();
        return ResponseHelper::sendResponseSuccess(null, Response::HTTP_OK, __('messages.done successfully'));
    }

    public function change_pregenant(PregenantRequest $request)
    {
        $patient = Patient::where("id", $request->patient_id)->first();
        $status = $request->action ? true : false;

        $patient->update(['pregenant_status' => $status]);
        return ResponseHelper::sendResponseSuccess(new PatientResource($patient), Response::HTTP_OK, __('messages.done successfully'));
    }
}
