<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Resources\NotificationResource;
use App\Http\Requests\Api\NotificationRequest;

class NotificationController extends Controller
{
    //
    public function notifications()
    {
        $notifications = Notification::where("user_id", auth("api")->id())->orderBy('id','desc')->paginate(20);
        return ResponseHelper::sendResponseSuccess(NotificationResource::collection($notifications)->response()->getData());
    }


    public function delete(NotificationRequest $request)
    {
        $notification = Notification::find($request->notification_id);
        if (!$notification)
            return ResponseHelper::sendResponseError(null, Response::HTTP_NOT_FOUND, __("messages_303.Not found"));
        $notification->delete();
        return ResponseHelper::sendResponseSuccess();
    }

    public function delete_all()
    {
        Notification::where('user_id', auth('api')->id())->delete();
        return ResponseHelper::sendResponseSuccess();
    }
}
