<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Patient;
use Illuminate\Http\Request;
use App\Models\TestGroupStepFive;
use App\Models\TestGroupStepFour;
use App\Models\TestGroupStepSeven;
use App\Models\TestGroupStepThree;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Models\TestGroupStepFourData;

class KPIController extends Controller
{
    public function index()
    {
        $data =  [

            [
                "title" => __('messages.Pregenancy rate'),
                "percentage" => $this->calc($this->number_of_pregnancies_after_embryo_transfer(), $this->total_number_of_cases_after_embryo_return()),
            ],
            [
                "title" => __("messages.Pregnancy rate with frozen embryos"),
                "percentage" => $this->calc($this->number_of_pregnancies_after_return_of_frozen_embryos(), $this->total_number_of_cases_after_return_of_frozen_embryos()),
            ],
            [
                "title" =>  __("messages.Miscarriage Rate"),
                "percentage" => $this->calc($this->number_of_miscarriages(), $this->number_of_total_pregnancies()),
            ],
            [
                "title" =>   __("messages.Fertilization rates for embryos"),
                "percentage"=> $this->calc($this->number_of_successfully_fertilized_eggs(), $this->number_of_mature_eggs()),
            ],
            [
                "title" => __("messages.Blastocysts formation rate"),
                "percentage" => $this->calc($this->number_of_blastocysts(), $this->number_of_fertilized_eggs_is_2pn()),

            ],
            [
                "title" =>  __("messages.Cleavage rate"),
                "percentage"  => $this->calc($this->total_number_of_embryos_on_the_second_day(), $this->number_of_fertilized_eggs_on_the_first_day_is_2pn()),

            ],
            [
                "title" => __("messages.Degeneration rate after ICSI"),
                "percentage" => $this->calc($this->number_of_damaged_eggs(), $this->number_of_eggs_injected()),

            ],
            [
                "title" => __("messages.Birth live rate"),
                "percentage" => $this->calc($this->number_of_live_birth(), $this->number_of_total_pregnancies()),

            ],






        ];
        return ResponseHelper::sendResponseSuccess($data);
    }




    private  function calc($count_1, $count_2)
    {
        $count_2 = $count_2 == 0 ? 1 : $count_2;
        $prec = ($count_1  /  $count_2) *  100;
        return  number_format($prec, 2) . " %";
    }





    // عدد حالات الحمل بعد ارجاع الاجنة
    public function number_of_pregnancies_after_embryo_transfer($patient_id = null)
    {
        $q =  TestGroupStepFive::where("pregnancy_status", "pregnant");
        return $this->filter_patient($q , $patient_id)->count();
    }

    // اجمالي عدد الحالات بعد ارجاع الاجنة
    public function total_number_of_cases_after_embryo_return($patient_id = null)
    {
         $q = TestGroupStepFive::query();

         return $this->filter_patient($q , $patient_id)->count();
    }

    //عدد حالات الحمل بعد ارجاع الاجنة المجمدة
    public function number_of_pregnancies_after_return_of_frozen_embryos($patient_id = null)
    {

        $q =  TestGroupStepSeven::where("pregnancy_status", "pregnant");
        return $this->filter_patient($q , $patient_id)->count();
    }

    //اجمالي عدد الحالات بعد ارجاع الاجنة المجمدة
    public function total_number_of_cases_after_return_of_frozen_embryos($patient_id = null)
    {
        $q =  TestGroupStepSeven::query();
        return $this->filter_patient($q , $patient_id)->count();
    }

    //عدد حالات الإجهاض
    public function number_of_miscarriages($patient_id = null)
    {
        $TestGroupStepFive =  TestGroupStepFive::where("pregnancy_status", "miscarriage");
        $TestGroupStepFive = $this->filter_patient($TestGroupStepFive , $patient_id)->count();



        $TestGroupStepSeven =  TestGroupStepSeven::where("pregnancy_status", "miscarriage");
        $TestGroupStepSeven = $this->filter_patient($TestGroupStepSeven , $patient_id)->count();



        return     $TestGroupStepFive  + $TestGroupStepSeven ;
    }

    //عدد حالات الحمل الكلي
    public function number_of_total_pregnancies($patient_id = null)
    {

        $TestGroupStepFive =  TestGroupStepFive::where("pregnancy_status", "pregnant");
        $TestGroupStepFive = $this->filter_patient($TestGroupStepFive , $patient_id)->count();



        $TestGroupStepSeven =  TestGroupStepSeven::where("pregnancy_status", "pregnant");
        $TestGroupStepSeven = $this->filter_patient($TestGroupStepSeven , $patient_id)->count();


        return     $TestGroupStepFive  + $TestGroupStepSeven ;
    }

    //عدد  البيوض المخصبة بنجاح
    public function number_of_successfully_fertilized_eggs($patient_id = null)
    {
        $q =  TestGroupStepFour::where("day", 1);
        return $this->filter_patient($q  , $patient_id)->sum('number_oocyte_fertilized');
    }


    //عدد البيوض الناضجة
    public function number_of_mature_eggs($patient_id = null)
    {
        $q =  TestGroupStepThree::query();
        return $this->filter_patient($q  , $patient_id)->sum('m_2');
    }


    // عدد ال abnormal
    public function number_of_abnormal_eggs($patient_id = null)
    {
        $q =  TestGroupStepThree::query();
        return $this->filter_patient($q  , $patient_id)->sum('abnormal');
    }

    // عدد البيوض الإجمالي موجود في تقرير  icsiويشمل مجموع عدد M1+M2+G
    public function number_of_eggs_all($patient_id = null)
    {
        $q =  TestGroupStepThree::query();

        $m_1 =          $this->filter_patient($q  , $patient_id)->sum('m_1');
        $m_2 =          $this->filter_patient($q  , $patient_id)->sum('m_2');
        $g_v =          $this->filter_patient($q  , $patient_id)->sum('g_v');
        $abnormal =     $this->filter_patient($q  , $patient_id)->sum('abnormal');

        return   $m_1 +   $m_2 + $g_v  +  $abnormal ;
    }

    //عدد ال blastocyst

    public function number_of_blastocysts($patient_id = null)
    {
        $q  = TestGroupStepFour::where("day", 5);
        return $this->filter_patient($q  , $patient_id)->sum('blastocyst');
    }

    //عدد  البيوض المخصبة 2pn

    public function number_of_fertilized_eggs_is_2pn($patient_id = null)
    {

        $q  = TestGroupStepFour::where("day", 1);
        return $this->filter_patient($q  , $patient_id)->sum('number_oocyte_fertilized');

    }

    // مجموع عدد الاجنة في اليوم الثاني

    public function total_number_of_embryos_on_the_second_day($patient_id = null)
    {
        $q = TestGroupStepFour::where("day", 2);

       $ids = $this->filter_patient($q , $patient_id)->pluck('id')->toArray();
        return TestGroupStepFourData::whereIn('test_group_step_four_id', $ids)->sum('number_embryos');
    }

    public function number_of_live_birth($patient_id = null)
    {
        $count = Patient::where('pregenant_status', true)->count();
        return $count;
    }

    //عدد البيوض المخصبة في اليوم الأول 2pn

    public function number_of_fertilized_eggs_on_the_first_day_is_2pn($patient_id = null)
    {
        $q =  TestGroupStepFour::where("day", 1);
        return $this->filter_patient($q , $patient_id)->sum('number_oocyte_fertilized');
    }

    //عدد البيوض التالفة

    public function number_of_damaged_eggs($patient_id = null)
    {
        $q =  TestGroupStepThree::query();
        return $this->filter_patient($q  , $patient_id)->sum('degeneration_rate_after_icsi');
    }


    //عدد البيوض التي تم حقنها

    public function number_of_eggs_injected($patient_id = null)
    {
        $q  = TestGroupStepThree::query();

        return $this->filter_patient($q , $patient_id)->sum('number_oocyte_injected');
    }

    public function filter_patient($query , $patient_id){

       return  $query->when($patient_id ,  function($q) use($patient_id) {
            $q->whereHas('analysis_patient' , function($q) use($patient_id){
                $q->whereHas('patient' , function($q)use($patient_id){
                    $q->where("id" , $patient_id);
                });
            });
        });
    }
}
