<?php

namespace App\Http\Controllers\Api\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Admin\InputGeneralAnalysis\VariableRequest;
use App\Http\Resources\InputVariableResource;
use App\Models\Variable;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class VariableController extends Controller
{



    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = Variable::when(request('key_words') ,  function($q){
            $q->where('name' , 'like' , '%'.request('key_words').'%');
        })->where('is_delete',0)->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(InputVariableResource::collection($data)->response()->getData());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.input-general-analysis.variables.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(VariableRequest $request)
    {
        Variable::create($request->validated());
        return ResponseHelper::sendResponseSuccess();

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */


    /**
     * Update the specified resource in storage.
     */
    public function update(VariableRequest $request)
    {
        $item = Variable::find($request->id);
        if(!$item){
            return ResponseHelper::sendNotFound();
        }
        $item->update($request->validated());
        return ResponseHelper::sendResponseSuccess();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(Request $request)
    {
        $item = Variable::find($request->id);
        if(!$item){
            return ResponseHelper::sendNotFound();
        }
        $item->delete();
        return ResponseHelper::sendResponseSuccess();

    }

    public function soft_delete(Request $request)
    {


        $item = Variable::where("id", $request->id)->first();

        if (!$item) {
            return ResponseHelper::sendNotFound();
        }

        $item->update(['is_delete' => true]);
        return ResponseHelper::sendResponseSuccess();
    }
}
