<?php

namespace App\Http\Controllers\Api\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperApp;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Admin\InputGeneralAnalysis\GeneralAnalysisRequest;
use App\Http\Resources\GeneralAnalysisResource;
use App\Http\Resources\InputGeneralAnalysisResource;
use App\Models\GeneralAnalysis;
use App\Models\GeneralAnalysisVariable;
use App\Models\Variable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use Throwable;

class GeneralAnalysisController extends Controller
{


    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = GeneralAnalysis::with(['variables:id,name'])->when(request('key_words'),  function ($q) {
            $q->where('name', 'like', '%' . request('key_words') . '%');
        })->where('is_delete', '0')->paginate(config('app.paginate_number'));
        return ResponseHelper::sendResponseSuccess(InputGeneralAnalysisResource::collection($data)->response()->getData());
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(GeneralAnalysisRequest $request)
    {
        DB::beginTransaction();
        try {



            $general_analysis = GeneralAnalysis::create([
                'name' => $request->name
            ]);

            $general_analysis->variables()->attach($this->get_variables($request));

            DB::commit();

            return ResponseHelper::sendResponseSuccess();
        } catch (Throwable $e) {
            DB::rollBack();
            HelperApp::set_log_catch("store general analysis", $e->getMessage());
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(GeneralAnalysisRequest $request)
    {

        DB::beginTransaction();
        try {


            $item = GeneralAnalysis::where("id", $request->id)->first();

            if (!$item) {
                return ResponseHelper::sendNotFound();
            }

            $item->update([
                'name' => $request->name
            ]);

            GeneralAnalysisVariable::where("general_analysis_id", $request->id)->delete();

            $item->variables()->attach($this->get_variables($request));

            DB::commit();
            return ResponseHelper::sendResponseSuccess();
        } catch (Throwable $e) {
            DB::rollBack();
            dd($e->getMessage());
            HelperApp::set_log_catch("update general analysis", $e->getMessage());
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }


    private function get_variables($request)
    {
        // set other variable
        $other_variables_ids = [];

        if ($request->other_variables  && count($request->other_variables)) {
            foreach ($request->other_variables as $item) {
                if ($item['name']) {
                    $variable = Variable::create([
                        "name" => $item['name'],
                        "default_value" => $item['default_value'],
                    ]);


                    $other_variables_ids[] = $variable->id;
                }
            }
        }


        $variables_ids = $other_variables_ids;
        if ($request->variables && count($request->variables)) {
            $variables_ids = array_merge($variables_ids, $request->variables);
        }

        return $variables_ids;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function delete(Request $request)
    {


        $item = GeneralAnalysis::where("id", $request->id)->first();

        if (!$item) {
            return ResponseHelper::sendNotFound();
        }


        $item->delete();
        return ResponseHelper::sendResponseSuccess();
    }

    public function soft_delete(Request $request)
    {


        $item = GeneralAnalysis::where("id", $request->id)->first();

        if (!$item) {
            return ResponseHelper::sendNotFound();
        }

        $item->update(['is_delete' => true]);
        return ResponseHelper::sendResponseSuccess();
    }
}
