<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperApp;
use App\Http\Helpers\HelperFile;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\GeneticLabRequest;
use App\Http\Requests\Api\GeneticLabRequestUpdate;
use App\Http\Resources\GeneticLabResource;
use App\Models\GeneticLab;
use App\Models\GeneticLabReport;
use App\Models\GeneticLabReportFiles;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class GeneticLabController extends Controller
{
    public function index(){
        $data = GeneticLab::orderBy("id"  , "desc")->when(request('key_words') , function($q) {
            $q->whereHas("patient" ,  function($q){
                $q->where("name" , "like"  , "%".request('key_words')."%")
                ->orWhere("other_name" , "like"  , "%".request('key_words')."%")
                ->orWhere("other_medical_file_number" , "like"  , "%".request('key_words')."%")
                ->orWhere("medical_file_number" , "like"  , "%".request('key_words')."%");
            });
        })->paginate(config('app.paginate_number'));
        return ResponseHelper::sendResponseSuccess(GeneticLabResource::collection($data)->response()->getData());
    }

    public function create(GeneticLabRequest $request){

        DB::beginTransaction();
        try{
            $genetic_lab = GeneticLab::create([
                'patient_id' => $request->patient_id,
                'biopsy_day' => $request->biopsy_day,
                'biopsy_by' => $request->biopsy_by,
                'witnessed_by' => $request->witnessed_by,
                'biopsy_medium' => $request->biopsy_medium,
                'report' => $request->report,
                'user_id'=>auth('api')->id(),
            ]);


            if($request->reports_fiels && count( $request->reports_fiels)){
                foreach($request->reports_fiels as $reports_fiels){
                    $report = GeneticLabReport::create([
                        "genetic_lab_id"=>$genetic_lab->id,
                        "type_report"=>$reports_fiels['type']
                    ]);

                    if(isset($reports_fiels['attachments']) && $reports_fiels['attachments'] && count( $request->reports_fiels)){
                        $files =[];
                        foreach($reports_fiels['attachments'] as $attachment){
                            $files[] = [
                                "genetic_lab_report_id"=>$report->id,
                                "path"=>HelperFile::upload($attachment,'genetic-lab-report')['path']
                            ];
                        }

                        GeneticLabReportFiles::insert($files);


                    }


                }
            }
            DB::commit();
            return ResponseHelper::sendResponseSuccess(null);

        }catch (\Exception $e){

            DB::rollBack();
            HelperApp::set_log_catch("create Genetic Lab" , $e->getMessage());
            return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , __("messages.An error occurred in data entry"));
        }





    }


    public function update(GeneticLabRequestUpdate $request){
        DB::beginTransaction();
        try{

            $genetic_lab = GeneticLab::find($request->id);
            $genetic_lab->update([
                'patient_id' => $request->patient_id,
                'biopsy_day' => $request->biopsy_day,
                'biopsy_by' => $request->biopsy_by,
                'witnessed_by' => $request->witnessed_by,
                'biopsy_medium' => $request->biopsy_medium,
                'report' => $request->report,
                'user_id'=>auth('api')->id(),

            ]);


            $old_reports= GeneticLabReport::where("genetic_lab_id" , $genetic_lab->id)->get();

            $old_files_data=[];
            foreach($old_reports as $old_report){
                $old_files = GeneticLabReportFiles::where("genetic_lab_report_id" , $old_report->id)->pluck("path")->toArray();
                $old_files_data[$old_report->type_report]=$old_files;
            }


            GeneticLabReport::where("genetic_lab_id" , $genetic_lab->id)->delete();

            if($request->reports_fiels && count( $request->reports_fiels)){
                foreach($request->reports_fiels as $reports_fiels){
                    $report = GeneticLabReport::create([
                        "genetic_lab_id"=>$genetic_lab->id,
                        "type_report"=>$reports_fiels['type']
                    ]);


                    $files =[];
                    if(isset($old_files_data[$reports_fiels['type']])   && count($old_files_data[$reports_fiels['type']])){
                        foreach($old_files_data[$reports_fiels['type']] as $old_file){
                            $files[]=[
                                "genetic_lab_report_id"=>$report->id,
                                "path"=>$old_file,
                            ];
                        }
                    }
                    if(isset($reports_fiels['attachments']) && $reports_fiels['attachments'] && count( $request->reports_fiels)){

                        foreach($reports_fiels['attachments'] as $attachment){
                            $files[] = [
                                "genetic_lab_report_id"=>$report->id,
                                "path"=>HelperFile::upload($attachment,'genetic-lab-report')['path']
                            ];
                        }
                    }


                    GeneticLabReportFiles::insert($files);


                }
            }

            DB::commit();
            return ResponseHelper::sendResponseSuccess(null);
        }catch (\Exception $e){

            DB::rollBack();
            HelperApp::set_log_catch("create Genetic Lab" , $e->getMessage());
            return ResponseHelper::sendResponseError(null ,  Response::HTTP_BAD_REQUEST , __("messages.An error occurred in data entry"));
        }


    }

    public function delete_file(Request $request){
        $request->validate(["file_id"=>"required|integer|exists:genetic_lab_report_files,id"]);

        $file = GeneticLabReportFiles::find($request->file_id);
        HelperFile::delete($file->path);
        $file->delete();
        return ResponseHelper::sendResponseSuccess(null);


    }


    public function delete_report(Request $request){
        $request->validate(["genetic_lab_report_id"=>"required|integer|exists:genetic_lab_reports,id"]);

        $report = GeneticLabReport::find($request->genetic_lab_report_id);
        // HelperFile::delete($file->path);
        $report->delete();
        return ResponseHelper::sendResponseSuccess(null);


    }

    public function delete(Request $request){
        $request->validate(["id"=>"required|integer|exists:genetic_labs,id"]);
        $GeneticLab = GeneticLab::find(($request->id));
        $GeneticLabReport = GeneticLabReport::where("genetic_lab_id" , $GeneticLab->id)->pluck("id")->toArray();

        $pathes =GeneticLabReportFiles::whereIn("genetic_lab_report_id" , $GeneticLabReport)->pluck("path")->toArray();

        foreach($pathes as $path){
            HelperFile::delete($path);
        }



        $GeneticLab->delete();
        return ResponseHelper::sendResponseSuccess(null);
    }


}

