<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\UserRoleEnum;
use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Resources\DataResource;
use App\Models\GeneralAnalysis;
use App\Models\GroupGeneralAnalysis;
use App\Models\Medication;
use App\Models\Patient;
use App\Models\TypeTestGroup;
use App\Models\User;
use Illuminate\Http\Request;

class DataController extends Controller
{
    public function patients(Request $request)
    {
        $request->validate(["key_words" => "required|string"]);
        $key_words = $request->key_words;
        $patients =  Patient::select('id', 'name', 'other_name')->where("name", "like", "%$key_words%")
            ->orWhere("occupation", "like", "%$key_words%")
            ->orWhere("mobile", "like", "%$key_words%")
            ->orWhere("place_of_residence", "like", "%$key_words%")
            ->orWhere("id_number", "like", "%$key_words%")
            ->orWhere("medical_file_number", "like", "%$key_words%")
            ->orWhere("other_name", "like", "%$key_words%")
            ->orWhere("other_occupation", "like", "%$key_words%")
            ->orWhere("other_mobile", "like", "%$key_words%")
            ->orWhere("other_place_of_residence", "like", "%$key_words%")
            ->orWhere("other_id_number", "like", "%$key_words%")
            ->orWhere("other_medical_file_number", "like", "%$key_words%")
            ->get();

        return ResponseHelper::sendResponseSuccess(DataResource::collection($patients));
    }


    public function doctors()
    {
        $doctors  = User::select('id', 'name')->where("type", UserRoleEnum::Doctor->value)->get();
        return ResponseHelper::sendResponseSuccess(DataResource::collection($doctors));
    }

    public function users()
    {
        $doctors  = User::select('id', 'name')->where("type", '!=', UserRoleEnum::Admin->value)->get();
        return ResponseHelper::sendResponseSuccess(DataResource::collection($doctors));
    }

    public function general_analysis()
    {
        $data = GeneralAnalysis::where('is_delete', 0)->get();
        return ResponseHelper::sendResponseSuccess(DataResource::collection($data));
    }


    public function ovarian_stimulation()
    {
        return $this->medication("ovarian_stimulation");
    }

    public function ovulation_trigger()
    {
        return $this->medication("ovulation_trigger");
    }

    public function medication($type)
    {
        $data = Medication::where("type", $type)->select("id", "name")->get();
        return ResponseHelper::sendResponseSuccess(DataResource::collection($data));
    }

    public function groups()
    {
        return ResponseHelper::sendResponseSuccess(DataResource::collection(GroupGeneralAnalysis::get()));
    }

    public function types()
    {
        return ResponseHelper::sendResponseSuccess(DataResource::collection(TypeTestGroup::get()));
    }
}
