<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Api\Cryopreservation\FreezingRequest;
use App\Http\Requests\Api\Cryopreservation\SpermRequest;
use App\Http\Requests\Api\Cryopreservation\ThawingRequest;
use App\Http\Resources\CryopreservationResource;
use App\Models\Cryopreservation;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CryopreservationController extends Controller
{



    public function index(){
        $data = Cryopreservation::with(['patient'])->orderBy("id" , "desc");
        $data = $this->filter($data)->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(CryopreservationResource::collection($data)->response()->getData());

    }


    private function filter($q){
        if(request('key_words')){
            $key_words = request('key_words');
            $q= $q->whereHas('patient' ,  function($q) use( $key_words){
                $q->where("name" , "like" , "%$key_words%")
                ->orWhere("occupation" , "like" , "%$key_words%")
                ->orWhere("mobile" , "like" , "%$key_words%")
                ->orWhere("place_of_residence" , "like" , "%$key_words%")
                ->orWhere("id_number" , "like" , "%$key_words%")
                ->orWhere("medical_file_number" , "like" , "%$key_words%")
                ->orWhere("other_name" , "like" , "%$key_words%")
                ->orWhere("other_occupation" , "like" , "%$key_words%")
                ->orWhere("other_mobile" , "like" , "%$key_words%")
                ->orWhere("other_place_of_residence" , "like" , "%$key_words%")
                ->orWhere("other_id_number" , "like" , "%$key_words%")
                ->orWhere("other_medical_file_number" , "like" , "%$key_words%");
            });
        }

        return $q;
    }


    public function freezing(FreezingRequest $request){
        return $this->set_data($request , "freezing");
    }


    public function thawing(ThawingRequest $request){
        return $this->set_data($request , "thawing");
    }


    public function sperm(SpermRequest $request){
        $sum_total_motility = $request->total_motility_progressive +  $request->total_motility_non_progressive + $request->total_motility_immotile;
        if($sum_total_motility != 100){
            return ResponseHelper::sendResponseError(null , Response::HTTP_BAD_REQUEST , __('messages.Total motility must be 100'));
        }
        return $this->set_data($request , "sperm");
    }


    private function set_data($request , $type){
        $data = $request->validated();
        $data['user_id']=auth('api')->id();
        $data['type']= $type;
        Cryopreservation::create($data);

        return ResponseHelper::sendResponseSuccess(null);
    }


}
