<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\NotificationTypeEnum;
use App\Models\User;
use App\Enums\UserRoleEnum;
use App\Models\VerifyEmail;
use Illuminate\Http\Response;
use App\Http\Helpers\HelperApp;
use Illuminate\Support\Facades\DB;
use App\Mail\EmailVerificationCode;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperNotification;
use App\Http\Helpers\ResponseHelper;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Requests\Api\LoginRequest;
use App\Http\Resources\UserAuthResource;
use App\Http\Requests\Api\RegisterRequest;
use App\Http\Requests\DeleteAccountRequest;
use App\Http\Requests\Api\VerifyEmailRequest;

class AuthController extends Controller
{
    //

    public function login(LoginRequest $request)
    {

        $check_is_delete_account = User::where('email', $request->email . "__DELETE__")->orWhere('mobile', $request->mobile . "__DELETE__")->first();

        if ($check_is_delete_account) {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __("messages_303.This email and phone number have been blocked from registering on the application"));
        }


        config()->set('jwt.ttl', 60 * 24 * 7); // end week

        if ($token = auth('api')->attempt(['email' => $request->email,  'password' => $request->password, 'is_delete' => 0,'is_block'=>0])) {


            $user = auth('api')->user();

            $user->token = $token;
            User::where('id', $user->id)->update(["fcm_token" => $request->fcm_token]);
            return ResponseHelper::sendResponseSuccess(new UserAuthResource($user), Response::HTTP_OK, __('messages_303.log in succssfully'));
        } else {
            return ResponseHelper::sendResponseError(null, Response::HTTP_BAD_REQUEST, __('messages_303.The password or email is incorrect'));
        }
    }

    public function logout()
    {
        auth('api')->logout();
        return ResponseHelper::sendResponseSuccess(null, Response::HTTP_OK, __('messages_303.log out succssfully'));
    }







    public function user_data()
    {
        return ResponseHelper::sendResponseSuccess(HelperApp::get_user_data_auth());
    }
}
