<?php

namespace App\Http\Controllers\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperFile;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\StaticFNAAnalysisRequest;
use App\Http\Requests\StaticIUIAnalysisRequest;
use App\Http\Requests\StaticSFAAnalysisRequest;
use App\Http\Resources\AndrologyResource;
use App\Models\AnalysisPatient;
use App\Models\StaticFilesAnalysis;
use App\Models\StaticFNAAnalysis;
use App\Models\StaticIUIAnalysis;
use App\Models\StaticSFAAnalysis;
use GuzzleHttp\Psr7\Response;
use Illuminate\Http\Request;

class AndrologyController extends Controller
{
    public function index()
    {
        $data =  AnalysisPatient::with('pgd.attachments')->orderBy('id', 'desc')->when(request('key_words'), function ($q) {
            $q->whereHas("patient",  function ($q) {
                $q->where("name", "like", "%" . request('key_words') . "%")
                    ->orWhere("other_name", "like", "%" . request('key_words') . "%")
                    ->orWhere("other_medical_file_number", "like", "%" . request('key_words') . "%")
                    ->orWhere("medical_file_number", "like", "%" . request('key_words') . "%");
            });
        })->when(request('patient_id'),function($q){
            $q->where('patient_id',request('patient_id'));
        })->withoutGlobalScope('notype')->whereHas('general_analysis',  function ($q) {
            $q->whereNotNull('type');
        })->paginate(config('app.paginate_number'));

        return ResponseHelper::sendResponseSuccess(AndrologyResource::collection($data)->response()->getData());
    }
    public function iui(StaticIUIAnalysisRequest $request)
    {
        if (!$this->check_type("iui")) {
            return ResponseHelper::sendNotFound(__('messages.Notfound'));
        }
        $this->set_data(StaticIUIAnalysis::class, $request, "iui");
        return ResponseHelper::sendResponseSuccess();
    }

    public function sfa(StaticSFAAnalysisRequest $request)
    {
        if (!$this->check_type("sfa")) {
            return ResponseHelper::sendNotFound(__('messages.Notfound'));
        }
        $this->set_data(StaticSFAAnalysis::class, $request, "sfa");
        return ResponseHelper::sendResponseSuccess();
    }


    public function fna(StaticFNAAnalysisRequest $request)
    {
        if (!$this->check_type("fna")) {
            return ResponseHelper::sendNotFound(__('messages.Notfound'));
        }
        $this->set_data(StaticFNAAnalysis::class, $request, "fna");
        return ResponseHelper::sendResponseSuccess();
    }


    public function show($analysis_patient_id, $type)
    {
        $data =  AnalysisPatient::where("id", $analysis_patient_id)->when(request('key_words'), function ($q) {
            $q->whereHas("patient",  function ($q) {
                $q->where("name", "like", "%" . request('key_words') . "%")
                    ->orWhere("other_name", "like", "%" . request('key_words') . "%")
                    ->orWhere("other_medical_file_number", "like", "%" . request('key_words') . "%")
                    ->orWhere("medical_file_number", "like", "%" . request('key_words') . "%");
            });
        })->withoutGlobalScope('notype')->whereHas('general_analysis',  function ($q) {
            $q->whereNotNull('type');
        })->first();
        if (!$data) {
            return ResponseHelper::sendNotFound();
        }


        if (!$data->$type) {
            $data = null;
        } else {
            $data  = new AndrologyResource($data);
        }

        return ResponseHelper::sendResponseSuccess($data);
    }


    private  function set_data($model, $request, $type)
    {
        $data = $request->validated();
        $data['user_id'] = auth('api')->id();
        $model::where("analysis_patient_id", $request->analysis_patient_id)->delete();
        $item = $model::create($data);


        if ($request->attachments && count($request->attachments)) {

            foreach ($request->attachments as $file) {
                $files[] = [
                    "path" => HelperFile::upload($file,  $type)['path'],
                    "type" => $type,
                    "type_id" => $item->id,
                ];
            }


            StaticFilesAnalysis::insert($files);
        }
    }


    private function check_type($type)
    {
        $analysis_patient = AnalysisPatient::withoutGlobalScope('notype')->find(request('analysis_patient_id'));
        if ($analysis_patient->general_analysis->type != $type) {
            return false;
        }
        return true;
    }
}
