<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\UserRoleEnum;
use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperFile;
use App\Http\Requests\Admin\UserRequest;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class UserController extends Controller
{
    public function __construct()
    {






        $this->middleware('permission:show_user')->only(['index', 'export']);
        $this->middleware('permission:create_user')->only(['create', 'store']);
        $this->middleware('permission:edit_user')->only(['update', 'edit']);
        $this->middleware('permission:block_user')->only(['block', 'unblock']);
        $this->middleware('permission:delete_user')->only(['destroy']);
    }



    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = User::where('type'  , '!=' , UserRoleEnum::Admin)->paginate(config('app.paginate_number'));
        return view('admin.users.index' , compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.users.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(UserRequest $request)
    {
        $data = $request->validated();

        $data['password'] = bcrypt($request->password);
        $data['email_verified_at'] = Carbon::now();
        if ($request->hasFile('image')) {
            $image = HelperFile::upload($request->file('image'), 'users');
            $data['image'] = $image['path'];
        }

        User::create($data);
        Alert::toast(__('messages.done successfully') , 'success');
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
         $item = User::where('type'  , '!=' , UserRoleEnum::Admin)->findOrfail($id);
        return view('admin.users.edit' , compact('item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UserRequest $request, string $id)
    {
        $item = User::where('type'  , '!=' , UserRoleEnum::Admin)->findOrfail($id);
        $data = $request->validated();


        if($request->password){

            $data['password'] = bcrypt($request->password);
        }else{
            unset($data["password"]);
        }

   
        if ($request->hasFile('image')) {
            HelperFile::delete($item->image);
            $image = HelperFile::upload($request->file('image'), 'users');
            $data['image'] = $image['path'];
        }

        $item->update($data);
        Alert::toast(__('messages.done successfully') , 'success');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $item = User::where('type'  , '!=' , UserRoleEnum::Admin)->findOrfail($id);
        if($item->image){
            HelperFile::delete($item->image);
        }
        $item->delete();
        Alert::toast(__("messages.done successfully") , "success");
    }

    public function block(string $id)
    {
        $item = User::where('type'  , '!=' , UserRoleEnum::Admin)->findOrfail($id);
        $item->is_block = 1;
        $item->save();
        Alert::toast(__("messages.done successfully"), "success");
        return back();
    }

    public function unblock(string $id)
    {
        $item = User::where('type'  , '!=' , UserRoleEnum::Admin)->findOrfail($id);
        $item->is_block = 0;
        $item->save();
        Alert::toast(__("messages.done successfully"), "success");
        return back();
    }


}
