<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\TypeTestGroupRequest;
use App\Models\TypeTestGroup;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class TypeTestGroupController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:show_type_test_group')->only(['index', 'export']);
        $this->middleware('permission:create_type_test_group')->only(['create', 'store']);
        $this->middleware('permission:edit_type_test_group')->only(['update', 'edit']);
        $this->middleware('permission:delete_type_test_group')->only(['destroy']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = TypeTestGroup::paginate(config('app.paginate_number'));
        return view('admin.type-test-group.index' ,  compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.type-test-group.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(TypeTestGroupRequest $request)
    {
        TypeTestGroup::create(['name'=>$request->name]);
        Alert::toast(__('messages.done successfully'));
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $item = TypeTestGroup::findOrFail($id);
        return view('admin.type-test-group.edit' , compact('item'));

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $item = TypeTestGroup::findOrFail($id);
        $item->update(['name'=>$request->name]);
        Alert::toast(__('messages.done successfully'));
        return back();

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $item = TypeTestGroup::findOrFail($id);
        $item->delete();
        Alert::toast(__('messages.done successfully'));
        return back();
    }
}
