<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Post;
use App\Models\Product;
use App\Models\Question;
use App\Models\ContactUs;
use App\Models\Department;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TrashedController extends Controller
{
    public function posts(){
        $data =  Post::onlyTrashed()->paginate(config("app.paginate_number"));
        return view("admin.trashed.posts" , compact("data"));
    }
    public function contact_us()
    {
        $data =  ContactUs::onlyTrashed()->paginate(config("app.paginate_number"));
        return view("admin.trashed.contact-us", compact("data"));
    }
    public function questions()
    {
        $data =  Question::onlyTrashed()->paginate(config("app.paginate_number"));
        return view("admin.trashed.questions", compact("data"));
    }
    public function departments()
    {
        $data =  Department::onlyTrashed()->paginate(config("app.paginate_number"));
        return view("admin.trashed.departments", compact("data"));
    }

    public function products()
    {
        $data =  Product::onlyTrashed()->paginate(config("app.paginate_number"));
        return view("admin.trashed.products", compact("data"));
    }

}
