<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\Device;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Requests\Admin\QualityManagementDeviceRequest;

class QualityManagementDeviceController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:show_device')->only(['index', 'export']);
        $this->middleware('permission:create_device')->only(['create', 'store']);
        $this->middleware('permission:edit_device')->only(['update', 'edit']);
        $this->middleware('permission:delete_device')->only(['destroy']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Device::orderBy('id', 'desc');
        $data = $data->when(request('key_words'), function ($q) {
            $q->where('name', 'like', '%' . request('key_words') . '%');
        })->when(request('type'),function($q){
            $q->where('type',request('type'));
        });
        $data = $data->paginate(config('app.paginate_number'));
        return view('admin.quality-management-devices.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('admin.quality-management-devices.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(QualityManagementDeviceRequest $request)
    {
        //
        $data = $request->validated();
        Device::create($data);
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $item = Device::findOrFail($id);
        return view('admin.quality-management-devices.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(QualityManagementDeviceRequest $request, string $id)
    {
        //
        $item = Device::findOrFail($id);
        $data = $request->validated();
        $item->update($data);
        Alert::toast(__("messages.done successfully"), "success");
        return back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        $item = Device::findOrFail($id);
        $item->delete();
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }
}
