<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Models\User;
use App\Models\Language;
use App\Enums\UserRoleEnum;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Http\Helpers\HelperData;
use App\Enums\NotificationTypeEnum;
use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperNotification;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Requests\Admin\UserNotifyRequest;
use App\Http\Requests\Admin\NotificationRequest;

class NotificationController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('permission:show_notification')->only(['index']);
        $this->middleware('permission:send_notification')->only(['create', 'store', 'user_notify', 'store_notify']);
    }

    public function index()
    {
        $data = Notification::whereNotNull('from_user_id')->paginate(config('app.paginate_number'));
        return view('admin.notifications.index', compact('data'));
    }

    public function create()
    {
        $languages = Language::active()->orderDefaultActive()->get();
        return view('admin.notifications.create', compact('languages'));
    }

    public function store(NotificationRequest $request)
    {
        if ($request->type == UserRoleEnum::Client->value)
            $user_type = HelperData::get_ids_client();
        elseif ($request->type == UserRoleEnum::Doctor->value)
            $user_type = HelperData::get_ids_doctor();
        elseif ($request->type == UserRoleEnum::Trainer->value)
            $user_type = HelperData::get_ids_trainer();
        elseif ($request->type == 'all')
            $user_type = HelperData::get_ids_all();

        HelperNotification::set_users_ids($user_type)
            ->set_type(NotificationTypeEnum::DashboardNotify->value)
            ->set_from_user_id(auth()->id())
            ->set_message(["ar" => $request->message_ar, "en" => $request->message_en])
            ->send_db()
            ->send_pusher()
            ->send_fcm()
            ->push_notification();


        Alert::toast(__("messages.done successfully"), 'success');

        return back();
    }

    public function user_notify($id)
    {
        $user = User::where('type', UserRoleEnum::Client->value)->findOrFail($id);
        $languages = Language::active()->orderDefaultActive()->get();
        return view('admin.users.notify', compact('languages', 'id', 'user'));
    }

    public function store_notify(UserNotifyRequest $request, $id)
    {

        User::where('type', UserRoleEnum::Client->value)->findOrFail($id);

        HelperNotification::set_users_ids([$id])
            ->set_type(NotificationTypeEnum::DashboardNotify->value)
            ->set_from_user_id(auth()->id())
            ->set_message(["ar" => $request->message_ar, "en" => $request->message_en])
            ->set_params($id)
            ->send_db()
            ->send_pusher()
            ->send_fcm()
            ->push_notification();


        Alert::toast(__("messages.done successfully"), 'success');

        return back();
    }
}
