<?php

namespace App\Http\Controllers\Admin\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\InputGeneralAnalysis\VariableRequest;
use App\Models\Variable;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class VariableController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:show_input_general_analysis_and_vars')->only(['index', 'export']);
        $this->middleware('permission:create_input_general_analysis_and_vars')->only(['create', 'store']);
        $this->middleware('permission:edit_input_general_analysis_and_vars')->only(['update', 'edit']);
        $this->middleware('permission:delete_input_general_analysis_and_vars')->only(['destroy']);
    }


    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = Variable::when(request('key_words'),  function ($q) {
            $q->where('name', 'like', '%' . request('key_words') . '%');
        })->where('is_delete', 0)->paginate(config('app.paginate_number'));
        return view('admin.input-general-analysis.variables.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.input-general-analysis.variables.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(VariableRequest $request)
    {
        Variable::create($request->validated());
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $item = Variable::findOrFail($id);
        return view('admin.input-general-analysis.variables.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(VariableRequest $request, string $id)
    {
        $item = Variable::findOrFail($id);
        $item->update($request->validated());
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $item = Variable::findOrFail($id);
        $item->delete();
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }

    public function soft_delete(string $id)
    {
        $item = Variable::findOrFail($id);
        $item->update(['is_delete', true]);
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }
}
