<?php

namespace App\Http\Controllers\Admin\InputGeneralAnalysis;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Helpers\HelperApp;
use App\Http\Helpers\ResponseHelper;
use App\Http\Requests\Admin\InputGeneralAnalysis\GeneralAnalysisRequest;
use App\Models\GeneralAnalysis;
use App\Models\GeneralAnalysisVariable;
use App\Models\Variable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use Throwable;

class GeneralAnalysisController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:show_input_general_analysis_and_vars')->only(['index', 'export']);
        $this->middleware('permission:create_input_general_analysis_and_vars')->only(['create', 'store']);
        $this->middleware('permission:edit_input_general_analysis_and_vars')->only(['update', 'edit']);
        $this->middleware('permission:delete_input_general_analysis_and_vars')->only(['destroy']);
    }


    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = GeneralAnalysis::with(['variables:id,name'])->when(request('key_words') ,  function($q){
            $q->where('name' , 'like' , '%'.request('key_words').'%');
        })->paginate(config('app.paginate_number'));
        return view('admin.input-general-analysis.general-analysis.index',  compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $variables = Variable::select('id', 'name', 'default_value')->where('is_delete',0)->get();
        return view('admin.input-general-analysis.general-analysis.create',  compact('variables'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(GeneralAnalysisRequest $request)
    {
        DB::beginTransaction();
        try {



            $general_analysis = GeneralAnalysis::create([
                'name' => $request->name
            ]);

            $general_analysis->variables()->attach($this->get_variables($request));

            DB::commit();
            Alert::toast(__('messages.done successfully'), 'success');
            return ResponseHelper::sendResponseSuccess(['url' => route('admin.input-general-analysis.general-analysis.create')]);
        } catch (Throwable $e) {
            DB::rollBack();
            HelperApp::set_log_catch("store general analysis", $e->getMessage());
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $item = GeneralAnalysis::findOrFail($id);
        $variables = Variable::select('id', 'name', 'default_value')->where('is_delete',0)->get();
        return view('admin.input-general-analysis.general-analysis.edit',  compact('variables', 'item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(GeneralAnalysisRequest $request, string $id)
    {

        DB::beginTransaction();
        try {


            $item = GeneralAnalysis::findOrFail($id);

            $item->update([
                'name' => $request->name
            ]);

            GeneralAnalysisVariable::where("general_analysis_id" , $id)->delete();

            $item->variables()->attach($this->get_variables($request));

            DB::commit();
            Alert::toast(__('messages.done successfully'), 'success');
            return ResponseHelper::sendResponseSuccess(['url' => route('admin.input-general-analysis.general-analysis.edit' , $id)]);
        } catch (Throwable $e) {
            DB::rollBack();
            HelperApp::set_log_catch("update general analysis", $e->getMessage());
            return ResponseHelper::sendResponseError(null,  Response::HTTP_BAD_REQUEST, __('messages.An error occurred in data entry'));
        }
    }


    private function get_variables($request)
    {
        // set other variable
        $other_variables_ids = [];

        if ($request->other_variables  && count($request->other_variables)) {
            foreach ($request->other_variables as $item) {
                if ($item['name']) {
                    $variable = Variable::create([
                        "name" => $item['name'],
                        "default_value" => $item['default_value'],
                    ]);


                    $other_variables_ids[] = $variable->id;
                }
            }
        }


        $variables_ids = $other_variables_ids;
        if ($request->variables && count($request->variables)) {
            $variables_ids = array_merge($variables_ids, $request->variables);
        }

        return $variables_ids;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $item = GeneralAnalysis::findOrFail($id);
        $item->delete();
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }

    public function soft_delete(string $id)
    {
        $item = GeneralAnalysis::findOrFail($id);
        $item->update(['is_delete',1]);
        Alert::toast(__('messages.done successfully'), 'success');
        return back();
    }
}
