<?php

namespace App\Http\Controllers\Admin;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\GroupGeneralRequest;
use App\Models\GeneralAnalysis;
use App\Models\GroupGeneralAnalysis;
use App\Models\GroupGeneralAnalysisItem;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class GroupGeneralController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:show_group_general_analysis')->only(['index', 'export']);
        $this->middleware('permission:create_group_general_analysis')->only(['create', 'store']);
        $this->middleware('permission:edit_group_general_analysis')->only(['update', 'edit']);
        $this->middleware('permission:delete_group_general_analysis')->only(['destroy']);
    }



    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = GroupGeneralAnalysis::with('general_analysis')->paginate(config('app.paginate_number'));
        return view('admin.group-general-analysis.index',  compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $general_analysis = GeneralAnalysis::where('is_delete', 0)->get();
        return view('admin.group-general-analysis.create',  compact('general_analysis'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(GroupGeneralRequest $request)
    {
        $group = GroupGeneralAnalysis::create(['name' => $request->name]);
        $items = [];

        foreach ($request->general_analysis as $id) {
            $items[] = [
                "group_general_analysis_id" => $group->id,
                "general_analysis_id" => $id,
            ];
        }

        GroupGeneralAnalysisItem::insert($items);
        Alert::toast(__('messages.done successfully'));
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $general_analysis = GeneralAnalysis::where('is_delete', 0)->get();
        $item = GroupGeneralAnalysis::with('general_analysis')->findOrFail($id);
        // $general_analysis_ids =  $item->general_analysis->pluck('general_analysis_id')->toArray();
        return view('admin.group-general-analysis.edit',  compact('general_analysis', 'item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(GroupGeneralRequest $request, string $id)
    {
        $group = GroupGeneralAnalysis::with('general_analysis')->findOrFail($id);


        $group->update(['name' => $request->name]);
        GroupGeneralAnalysisItem::where('group_general_analysis_id', $group->id)->delete();
        $items = [];

        foreach ($request->general_analysis as $id) {
            $items[] = [
                "group_general_analysis_id" => $group->id,
                "general_analysis_id" => $id,
            ];
        }

        GroupGeneralAnalysisItem::insert($items);
        Alert::toast(__('messages.done successfully'));
        return back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $group = GroupGeneralAnalysis::with('general_analysis')->findOrFail($id);
        $group->delete();
        Alert::toast(__('messages.done successfully'));
        return back();
    }

    
}
