<?php

namespace App\Http\Controllers\Admin;

use App\Enums\UserRoleEnum;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AdminRequest;
use App\Models\User;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;
use Rap2hpoutre\FastExcel\FastExcel;
class AdminController extends Controller
{
    public function __construct()
    {


        $this->middleware('permission:admins');
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = User::where('id' , '!=' , auth()->id())->where('type' ,UserRoleEnum::Admin);
        if(request('key_words')){
            $data = $data->where(function ($q) {
                $key_words = request('key_words');
                $q->where('name', 'like', "%{$key_words}%")
                    ->orWhere('email', 'like', "%{$key_words}%");
            });
        }

        $data = $data->paginate(config('app.paginate_number'));
        return view('admin.admins.index' ,compact('data'));
    }


    public function export(){
        $data = User::where('id' , '!=' , auth()->id())->select('name' , 'email' , 'is_block')->where('type' ,UserRoleEnum::Admin);
        if(request('key_words')){
            $data = $data->where(function ($q) {
                $key_words = request('key_words');
                $q->where('name', 'like', "%{$key_words}%")
                    ->orWhere('email', 'like', "%{$key_words}%");
            });
        }

        $data = $data->get()->makeHidden('is_block');
        return (new FastExcel($data))->download('admins.xlsx');


    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {


        return view('admin.admins.create');


    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(AdminRequest $request)
    {
        $data = [
            "name"=>$request->name,
            "email"=>$request->email,
            "password"=>bcrypt($request->password),
            "type"=>UserRoleEnum::Admin,
        ];


        $admin = User::create($data);
        if($request->permissions){
            $admin->givePermissionTo($request->permissions);
        }


        Alert::toast(__("messages.done successfully") , "success");
        return back();
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        // return auth('web')->id();
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $admin = User::where("type" ,UserRoleEnum::Admin)->where('id' , '!=' , auth()->id())->findOrfail($id);
        $permissions_admin = $admin->getAllPermissions()->pluck('name')->toArray();
        // dd($permissions_admin);

        return view('admin.admins.edit' ,  compact('admin' , 'permissions_admin'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(AdminRequest $request, string $id)
    {
        //
        $admin = User::where("type" ,UserRoleEnum::Admin)->where('id' , '!=' , auth()->id())->findOrfail($id);
        $data = [
            "name"=>$request->name,
            "email"=>$request->email,
            "type"=>UserRoleEnum::Admin,
        ];



        if($request->password){
            $data["password"] = bcrypt($request->password);
        }


        $admin->update($data);
        if($request->permissions){
            $admin->syncPermissions($request->permissions);
        }
        Alert::toast(__("messages.done successfully") , "success");
        return back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $item = User::where('id' , '!=' , auth()->id())->where('type' ,UserRoleEnum::Admin)->findOrfail($id);
        $item->delete();
        Alert::toast(__("messages.done successfully") , "success");
        return back();
    }


    public function block(string $id)
    {
        $item = User::where('id' , '!=' , auth()->id())->where('type' , UserRoleEnum::Admin)->findOrfail($id);
        $item->is_block=1;
        $item->save();
        Alert::toast(__("messages.done successfully") , "success");
        return back();
    }

    public function unblock(string $id)
    {
        $item = User::where('id' , '!=' , auth()->id())->where('type' ,UserRoleEnum::Admin)->findOrfail($id);
        $item->is_block=0;
        $item->save();
        Alert::toast(__("messages.done successfully") , "success");
        return back();
    }
}
