<?php

namespace App\Events;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NotificationEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $data;
    private $event;
    private $channels;




    public function __construct($data ,  $channels ,  $event )
    {
        $this->data = $data;
        $this->channels = $channels;
        $this->event = $event;
    }

    public function broadcastOn()
    {
        return $this->channels;
    }

    public function broadcastAs()
    {
        return $this->event;
    }
}
