<?php

namespace App\Enums;

enum ProtocolTypeEnum: string
{
    case LongAgonistDownRegulation = 'long_agonist_down_regulation';
    case ShortAgonist = 'short_agonist';
    case Antagonist = 'antagonist';
    case UltraShortAgonist = 'ultra_short_agonist';
    case NaturalCycleIVF = 'natural_cycle_ivf';
    case MildStimulationIVF = 'mild_stimulation_ivf';
    case InVitroMaturationIVM = 'in_vitro_maturation_ivm';
    case FrozenEmbryoTransferFET = 'frozen_embryo_transfer_fet';

    public static function values()
    {
        $items = [];

        foreach (ProtocolTypeEnum::cases() as $role) {
            $items[] = $role->value;
        }

        return  $items;
    }

}
