<?php

namespace App\Enums;

enum GeneticlabReportEnum: string
{
    case PGT_A = 'pgt_a';
    case CGT = 'cgt';
    case PGT_SR = 'pgt_sr';
    case PGT_M = 'pgt_m';
    case PRE_PGT_M = 'pre_pgt_m';
    case NACE = 'nace';
    case KARYOTYPING = 'karyotyping';
    case POC = 'poc';
    case NI_POC = 'ni_poc';
    case NGS = 'ngs';
    case ERA = 'era';
    case EMMA = 'emma';
    case ALICE = 'alice';
    case ENDOMETRIO = 'endometrio';
    case WES = 'wes';
    case CMA_750K = 'cma_750k';
    case CMA_HD = 'cma_hd';







    public static function values()
    {
        $items = [];

        foreach (GeneticlabReportEnum::cases() as $role) {
            $items[] = $role->value;
        }

        return  $items;
    }


    public static function key_values()
    {
        $items = [];
        foreach (GeneticlabReportEnum::cases() as $role) {
            $items[$role->name] = $role->value;
        }

        return  $items;
    }
}
