<?php

namespace App\Enums;

enum FemaleFactorEnum: string
{
    case PolycysticOvarySyndrome = 'polycystic_ovary_syndrome';
    case ThyroidDisorders = 'thyroid_disorders';
    case PituitaryDisorders = 'pituitary_disorders';
    case Hyperprolactinemia = 'hyperprolactinemia';
    case DiminishedOvarianReserve = 'diminished_ovarian_reserve';
    case PrimaryOvarianInsufficiency = 'primary_ovarian_insufficiency';
    case FallopianTubeDamageBlockage = 'fallopian_tube_damage_blockage';
    case UterineFibroids = 'uterine_fibroids';
    case Endometriosis = 'endometriosis';
    case UterineScarring = 'uterine_scarring';
    case CongenitalAbnormalitiesInTheUterus = 'congenital_abnormalities_in_the_uterus';
    case GeneticAndHereditaryFactors = 'genetic_and_hereditary_factors';
    case EndometrialPolyps = 'endometrial_polyps';
    case ObesityOrUnderweight = 'obesity_or_underweight';
    case ChronicDiseases = 'chronic_diseases';
    case LifeStyle = 'life_style';
    case OtherFactor = 'other_factor';

    public static function values()
    {
        $items = [];

        foreach (FemaleFactorEnum::cases() as $role) {
            $items[] = $role->value;
        }

        return  $items;
    }



}
