<?php

namespace App\Enums;

enum DeviceTypeEnum: string
{
    case IncubatorQualityControlLog = 'incubator_quality_control_log';
    case IncubatorQualityControlLogBenchtop = 'incubator_quality_control_log_benchtop';
    case HeatedIncubator = 'heated_incubator';
    case WorkstationsAndLaminarFlowCabinets = 'workstations_and_laminar_flow_cabinets';
    case MicromanipulatorAndIcsiStation = 'micromanipulator_and_icsi_station';
    case AirPurifiersDevice = 'air_purifiers_device';
    case Co2AndN2CylinderGasLevelCheck = 'co2_and_n2_cylinder_gas_level_check';
    case TankLiquidNitrogenLevelCheck = 'tank_liquid_nitrogen_level_check';
    case RefrigeratorsTemperatureLog = 'refrigerators_temperature_log';
    case LabEnvironment = 'lab_environment';
    case GeneralLabCleaning = 'general_lab_cleaning';







    public static function values()
    {
        $items = [];

        foreach (DeviceTypeEnum::cases() as $role) {
            $items[] = $role->value;
        }

        return  $items;
    }


    public static function key_values()
    {
        $items = [];
        foreach (DeviceTypeEnum::cases() as $role) {
            $items[$role->name] = $role->value;
        }

        return  $items;
    }

    public static function format_text($text)
    {
        $text = str_replace('_', ' ', $text);
        $text = preg_replace('/([a-z])([A-Z])/', '$1 $2', $text);
        return ucwords($text);
    }
}
